package Application::Model::API::Yandex::Maps;

use qbit;

use Exception::API::Maps;
use Exception::Validation::BadArguments;
use XML::Simple;

use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

sub accessor {'api_http_maps'}

sub get_companies_by_ll {
    my ($self, $ll, $opts) = @_;

    my %params = $self->_fix_request_params($opts);
    $params{mode}    = 'reverse';
    $params{type}    = 'biz';
    $params{results} = 1000;

    my ($lat, $lon) = split /,/, $ll;
    $params{ll} = "$lon,$lat";

    my @data;
    try {
        my $json = $self->call('', %params);
        my $parsed_json = from_json($json);

        return []
          unless exists($parsed_json->{reply}{geo_object});

        my @org_list = @{$parsed_json->{reply}{geo_object}};

        for my $geo_object (@org_list) {
            for my $metadata (@{$geo_object->{metadata}}) {
                next unless exists($metadata->{'yandex.maps.proto.search.business.GEO_OBJECT_METADATA'});
                my $business_metadata = $metadata->{'yandex.maps.proto.search.business.GEO_OBJECT_METADATA'};
                my $categories = [map {$_->{name}} @{$business_metadata->{category}}];
                push @data,
                  {
                    name         => $business_metadata->{name},
                    business_oid => $business_metadata->{id},
                    categories   => $categories,
                  };
            }
        }
    }
    catch {
        my ($exception) = @_;

        throw Exception::API::Maps $exception;
    };

    return \@data;
}

sub check_business_oid {
    my ($self, $business_oid, $opts) = @_;

    my %params = $self->_fix_request_params($opts);
    $params{business_oid} = $business_oid;

    my $message;
    my $found = 0;

    try {
        my $json = $self->call('', %params);
        my $parsed_json = from_json($json);

        for my $metadata (@{$parsed_json->{reply}{metadata}}) {
            if (exists($metadata->{'yandex.maps.proto.search.search.RESPONSE_METADATA'})) {
                $found = $metadata->{'yandex.maps.proto.search.search.RESPONSE_METADATA'}{found};
            }
        }

        $message = gettext("Can't found organization with business_oid '%s'", $business_oid) if !$found;
    }
    catch {
        my ($exception) = @_;

        throw Exception::API::Maps $exception;
    };

    return {result => $found, message => $message};
}

sub _fix_request_params {
    my ($self, $opts) = @_;

    # ??
    my $lang = ($self->get_option('cur_user', {})->{language} // '') eq 'en' ? 'en_US' : 'ru_RU';

    return (
        'lang' => $opts->{lang} // $lang,
        'origin' => 'pi2backend',
        'ms'     => 'pb',
        'hr'     => 'json',
    );
}

sub check_tvm_service {
    my ($self) = @_;

    my $result;
    try {
        $self->check_business_oid(1);
    }
    catch {
        my ($e) = @_;
        if ($e->message =~ /401 Unauthorized/) {
            $result = TRUE;
        }
    };

    return $result;
}

TRUE;
