package Application::Model::API::Yandex::MoneyMap;

use qbit;

use base qw(QBit::Application::Model::API::Yandex::MoneyMap Application::Model::API::HTTPLogger);

sub accessor {'api_moneymap'}

my $MONEYMAP_CHUNK_SIZE = 1000;

sub add_page {
    my ($self, %params) = @_;

    if ($params{opts_moneymap}) {
        return $self->pages(
            ':post'    => 1,
            ':content' => to_json(
                {
                    pages => [
                        {
                            %{$params{opts_moneymap}},
                            login        => $params{login},
                            page_caption => $params{page_caption},
                            page_id      => $params{page_id},
                        }
                    ]
                }
            ),
        );
    }
}

sub edit_page {
    my ($self, %params) = @_;

    if ($params{opts_moneymap}) {
        return $self->pages(
            ':patch'   => 1,
            ':content' => to_json(
                {
                    pages => [
                        {
                            %{$params{opts_moneymap}},
                            login        => $params{login},
                            page_caption => $params{page_caption},
                            page_id      => $params{page_id},
                        }
                    ]
                }
            ),
        );
    }
}

sub add_block {
    my ($self, %params) = @_;

    if ($params{opts_moneymap}) {
        return $self->blocks(
            ':post'    => 1,
            ':content' => to_json(
                {
                    blocks => [
                        {
                            %{$params{opts_moneymap}},
                            login    => $params{login},
                            page_id  => $params{page_id},
                            block_id => $params{block_id},
                        }
                    ]
                }
            ),
        );
    }
}

sub edit_block {
    my ($self, %params) = @_;

    if ($params{opts_moneymap}) {
        return $self->blocks(
            ':patch'   => 1,
            ':content' => to_json(
                {
                    blocks => [
                        {
                            %{$params{opts_moneymap}},
                            login    => $params{login},
                            page_id  => $params{page_id},
                            block_id => $params{block_id},
                        }
                    ]
                }
            ),
        );
    }
}

sub get_fields {
    my ($self, $traffic_type) = @_;

    if ($traffic_type) {
        my $by_traffic_type = $self->fields()->{traffic_types};
        return {
            traffic_types => $by_traffic_type,
            traffic_type  => $traffic_type,
        };
    }
}

sub get_pages_by_ids {
    my ($self, $page_ids, $is_internal) = @_;

    my $result = {};

    while (my @part = splice(@$page_ids, 0, $MONEYMAP_CHUNK_SIZE)) {

        my $filter = {'page_id[eq]' => \@part,};
        if (defined($is_internal)) {
            $filter->{is_internal} = $is_internal ? JSON::XS::true : JSON::XS::false;
        }

        my $moneymap_response = $self->pages(
            ":content" => to_json({"filter" => $filter}),
            'limit'    => scalar @part
        );
        my $moneymaps = $moneymap_response->{'pages'} // [];

        map {$result->{$_->{'page_id'}} = $_} @$moneymaps;
    }

    return $result;
}

sub get_blocks_by_ids {
    my ($self, $block_ids, $is_internal) = @_;

    my $result = {};

    while (my @part = splice(@$block_ids, 0, $MONEYMAP_CHUNK_SIZE)) {

        my $filter = {'block[eq]' => \@part,};
        if (defined($is_internal)) {
            $filter->{is_internal} = $is_internal ? JSON::XS::true : JSON::XS::false;
        }

        my $moneymap_response = $self->blocks(":content" => to_json({"filter" => $filter}),);
        my $moneymaps = $moneymap_response->{'blocks'} // [];

        $result->{$_->{'page_id'}}{$_->{'block_id'}} = $_ foreach @$moneymaps;
    }

    return $result;
}

sub is_owner_internal {
    my ($self, $owner_login) = @_;

    if ($owner_login) {
        return 0 < grep {$owner_login eq $_} @{$self->app->api_moneymap->get_internal_owners()};
    }

    return 0;
}

TRUE;
