package Application::Model::API::Yandex::News;

use qbit;

use Exception::API::News;
use Exception::Validation::BadArguments;

use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

sub accessor {'api_http_news'}

sub check_sources {
    my ($self, $sources, $opts) = @_;

    my %params = $self->_fix_request_params($opts);
    $params{source_id} = $sources // [];

    my $path = 'v2/recommend_by_host';
    my $message;
    my $bad_id;
    my $result = 0;

    try {
        $result = $self->call($path, %params);
        my $data = from_json($result);
        $result = ref $data->{items} eq 'ARRAY' ? scalar @{$data->{items}} : 0;
        $message = gettext("Source_id doesn't contain pictures.") if !$result;
    }
    catch Exception::API::HTTP with {
        my ($exception) = @_;
        if (   $exception->_get_response() =~ /There is no valid source id(.*)/
            || $exception->_get_response() =~ /Bad source_id:( \d*),/)
        {
            $message = gettext("Bad source id%s", $1);
        } else {
            throw Exception::API::News $exception;
        }
    }
    catch Exception::Validation::BadArguments::InvalidJSON with {
        my ($exception) = @_;
        throw Exception::API::News $exception;
    };

    return {result => $result, message => $message};
}

sub _fix_request_params {
    my ($self, $opts) = @_;

    return (
        'count'         => $opts->{count}         // 4,
        'need_picture'  => $opts->{need_picture}  // 1,
        'picture_sizes' => $opts->{picture_sizes} // '480.320.1.orig',
        'strong_check'  => $opts->{strong_check}  // 1
    );
}

TRUE;
