package Application::Model::API::Yandex::RMP;

use qbit;
use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

use Exception::RMP;

sub accessor {'api_rmp'}

# /v1/api/uac/app_info/add?url=https://play.google.com/store/apps/details?id=ru.mocked.app
sub get_app_info {
    my ($self, %opts) = @_;

    my $response;
    try {
        my $r = $self->call(
            'app_info/add',
            ':headers' => {'Content-Type' => 'application/json', 'Accept' => 'application/vnd.api+json'},
            ':post'    => 1,
            # query POST params, without this don't work GET params
            ':content' => '{}',
            # query GET params
            'url' => $opts{store_url},
        );
        $response = from_json($r, keep_utf => TRUE)->{'data'}->[0];
    }
    catch {
        my ($e) = @_;
        throw Exception::RMP $e;
    };

    %$response = hash_transform(
        $response,
        [qw(icon developer apple_store_id store_id)],
        {
            icon    => 'icon',
            author  => 'developer',
            storeId => 'apple_store_id',
            bundle  => 'store_id',
        }
    );

    return $response;
}

sub check_tvm_service {
    my ($self) = @_;

    my $result;
    try {
        my $res = $self->call(
            'app_info/search',
            text        => '',
            queryFields => 's_bundle_id',
            limit       => 1,
        );
    }
    catch {
        my ($e) = @_;
        if ($e->message =~ /403 Forbidden/) {
            $result = TRUE;
        }
    };

    return $result;
}

TRUE;
