package Application::Model::API::Yandex::SelfService;

use qbit;
use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

use Time::HiRes;

__PACKAGE__->model_accessors('validator' => 'Application::Model::Validator');

sub accessor {'api_selfservice'}

our $skip_log_ok;
sub need_log_all {!$skip_log_ok}

sub logbroker {
    my ($self, %opts) = @_;

    local $skip_log_ok = delete $opts{skip_log_ok};
    $self->validator->check(
        data     => \%opts,
        template => {
            type   => 'hash',
            fields => {
                append_time_name => {
                    len_min  => 1,
                    optional => TRUE,
                    type     => 'scalar',
                },
                data => {
                    type => 'array',
                    all  => {
                        extra => TRUE,
                        type  => 'hash',
                    },
                },
                topic => {
                    len_min => 1,
                    type    => 'scalar',
                },
            },
        },
        throw => TRUE,
    );

    return TRUE unless @{$opts{data}};

    my $tm       = Time::HiRes::time;
    my $unixtime = int($tm * 1_000);

    my @lines = map {
        to_json(
            (
                     exists($_->{unixtime})
                  || exists($_->{UnixTime}) ? $_ : {%$_, ($opts{append_time_name} // 'unixtime') => $unixtime}
            ),
            canonical => 1
          )
    } @{$opts{data}};

    $self->call(
        'logbroker',
        ':post'    => 1,
        ':headers' => {'Content-Type' => 'application/json',},
        ':content' => to_json(
            {
                destination => 'logbroker',
                endpoint    => $opts{topic},
                payload     => \@lines,
            }
        ),
    );

    return TRUE;
}

TRUE;
