package Application::Model::API::Yandex::SelfemployedOeBS;

use qbit;

use base qw(QBit::Application::Model::API::Yandex::SelfemployedOeBS Application::Model::API::HTTPLogger);

sub accessor {'api_selfemployed_oebs'}

sub get_yandex_receipts {
    my ($self, $partner_inn) = @_;

    my $YANDEX_PARTNER_CODE = $self->get_option('partner_code');

    my @receipt_list;

    my ($inn, $from, $to, $limit, $offset) =
      ($partner_inn, trdate('norm', 'yt', date_sub(curdate(), year => 1)), curdate(oformat => 'yt'), 100, 0);

    my $has_more = TRUE;
    while ($has_more) {
        my $answer = $self->get_receipts($inn, $from, $to, $limit, $offset);

        $has_more = $answer->{response}{hasMore} // FALSE;
        $offset += $limit;

        push @receipt_list, map {
            {
                period_start_date => $_->{requestTime},
                period_end_date   => $_->{requestTime},
                external_id       => '',
                multistate_name   => (
                    $_->{cancelationTime}
                    ? gettext('Cancelled receipt # %s', $_->{receiptId})
                    : gettext('Got receipt # %s',       $_->{receiptId})
                  )
                  . ($_->{services}[0]{name} ? ': ' . $_->{services}[0]{name} : ''),
                link => $_->{link},
            }
          }
          grep {
            $YANDEX_PARTNER_CODE eq $_->{partnerCode}
          } @{$answer->{receipts}};
    }

    return \@receipt_list;
}

TRUE;
