package Application::Model::API::Yandex::Staff;

use qbit;
use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

use List::Util qw(min);

my $CHUNK_SIZE = 50;

sub accessor {'api_staff'}

sub call {
    my ($self, @data) = @_;

    my $content = $self->SUPER::call(@data);
    if ($content) {
        utf8::decode($content) unless utf8::is_utf8($content);
        $content = from_json($content);
    }

    return $content;
}

# Документация: https://staff-api.yandex-team.ru/v3/persons?_doc=1
sub persons {
    my ($self, %opts) = @_;

    my $fields = delete $opts{fields};
    $opts{'_fields'} //= join(',', @$fields) if (ref $fields eq 'ARRAY');

    my $filter = delete $opts{filter};
    if (ref $filter eq 'HASH') {
        foreach my $key (keys %$filter) {
            my $value = $filter->{$key};
            $value = join(',', @$value) if (ref $value eq 'ARRAY');
            $opts{$key} = $value;
        }
    }

    $self->call(persons => %opts);
}

sub is_dismissed {
    my ($self, $logins) = @_;

    my @result;
    # Отправляем на проверку с разбивкой по пачкам
    for (my $i = 0; $i <= int(scalar(@$logins) / $CHUNK_SIZE); $i++) {
        my $data = $self->persons(
            fields => [qw(login official.is_dismissed)],
            filter => {
                login => [@$logins[$i * $CHUNK_SIZE .. min($i * $CHUNK_SIZE + $CHUNK_SIZE - 1, $#$logins)]],
                'official.is_dismissed' => 'true',
            },
        );
        push @result, map {$_->{official}{is_dismissed} ? $_->{login} : ()} @{$data->{result} // []};
    }

    return \@result;
}

sub check_tvm_service {
    my ($self) = @_;

    my $result;
    try {
        $self->is_dismissed(['pi']);
    }
    catch {
        my ($e) = @_;
        if ($e->isa('Exception::API::HTTP') && $e->{response}->code == 401) {
            $result = TRUE;
        }
    };

    return $result;
}

TRUE;
