package Application::Model::API::Yandex::UtilsPartner2;

use qbit;

use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

use Exception::API::UtilsPartner2;

my $SERVICE = 'pi2';

sub accessor {'api_utils_partner2'}

sub call {
    my ($self, $url, %params) = @_;

    my $result;
    try {
        my $json = $self->SUPER::call($url, %params);

        $result = from_json($json);
    }
    catch {
        throw Exception::API::UtilsPartner2 shift;
    };

    throw Exception::API::UtilsPartner2 gettext('Incorrect answer') if ref($result) ne 'HASH';

    throw Exception::API::UtilsPartner2 $result->{'error_message'} if exists($result->{'error_message'});

    return $result;
}

=head2 get_next_page_id

    my $page_id = $app->api_utils_partner2->get_next_page_id();

=cut

sub get_next_page_id {
    my ($self) = @_;

    my $result = $self->call('/intapi/get_next_page_id', service => $SERVICE, ':post' => TRUE);

    return $result->{'page_id'};
}

=head2 alive

    $app->api_utils_partner2->alive();

Кидает исключение если не alive.

=cut

sub alive {
    my ($self) = @_;

    my $result = $self->call('/alive');

    throw Exception::API::UtilsPartner2 'Not alive' if $result->{success} ne '1';

    return 1;
}

TRUE;
