package Application::Model::BKLanguage;

use qbit;

use base qw(Application::Model::DBManager::Base RestApi::MultistateModel);

use Utils::JSON qw(fix_type_for_complex);

use Exception::Validation::BadArguments::EmptyValue;
use Exception::Denied;
use Exception::Validation::BadArguments;

sub accessor      {'bk_language'}
sub db_table_name {'bk_language'}

sub get_product_name {
    gettext('bk_language');
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'id',           label => gettext('Soft ID')},
        {name => 'language',     label => gettext('Caption')},
        {name => 'display_name', label => gettext('Display name')},
    ];
}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB',);

__PACKAGE__->register_rights(
    [
        {
            name        => 'bk_language',
            description => d_gettext('Right to manage bk languages'),
            rights      => {bk_language_view => d_gettext('Right to view bk language'),}
        }
    ]
);

__PACKAGE__->model_fields(
    available_fields => {
        label => d_gettext('Available fields'),
        get   => sub {
            return $_[0]->model->get_available_fields($_[1]);
        },
        type        => 'complex',
        fix_type    => \&fix_type_for_complex,
        adjust_type => 'hash_int',
    },
    display_name => {
        api     => TRUE,
        default => TRUE,
        db      => TRUE,
        i18n    => TRUE,
        type    => 'string',
    },
    fields_depends => {
        get => sub {
            return {};
        },
    },
    id => {
        api         => TRUE,
        default     => TRUE,
        db          => TRUE,
        pk          => TRUE,
        type        => 'number',
        adjust_type => 'str',
    },
    language => {
        api     => TRUE,
        default => TRUE,
        db      => TRUE,
        type    => 'string',
    },
    public_id => {
        db      => TRUE,
        db_expr => 'id',
        type    => 'string',
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id           => {type => 'number', label => d_gettext('ID')},
        language     => {type => 'text',   label => d_gettext('Caption')},
        display_name => {type => 'text',   label => d_gettext('Display name')},
    },
);

sub get_available_fields {
    my ($self) = @_;

    return {map {$_ => TRUE} $self->api_available_fields};
}

sub query {
    my ($self, %opts) = @_;

    return $self->partner_db->query->select(
        table  => $self->partner_db_table(),
        fields => $opts{'fields'}->get_db_fields(undef),
        filter => $opts{'filter'}
    )->order_by('id');
}

sub api_available_actions {
    return ();
}

TRUE;
