package Application::Model::BKStatistics::Fields;

use qbit;

use PiConstants qw(
  $CATEGORY_NAMES
  $CATEGORY_COUNTER
  $CATEGORY_CALCULATED
  $CATEGORY_CASH
  $CATEGORY_PAGE_FIELDS
  $CATEGORY_CALCULATED_WITH_MONEY
  $CATEGORY_RECOMMENDATIONS

  $MOL_STAT_TYPES
  $MOL_REPORT_TYPE_MAIN
  $MOL_REPORT_TYPE_DSP
  $MOL_REPORT_TYPE_MM

  $CATEGORY_MOL_BASIC
  $CATEGORY_MOL_ANALYTIC
  $CATEGORY_MOL_FINANCIAL
  $CATEGORY_MOL_ADDITIONAL
  $CATEGORY_MOL_RECOMMENDATIONS
  $CATEGORY_MOL_DSP
  $CATEGORY_MOL_APPLICATION
  $CATEGORY_MOL_ADV_PLACE
  $CATEGORY_MOL_MONITEZATION

  $CATEGORY_TRAFFIC
  $CATEGORY_MONETIZER
  $CATEGORY_ADFOX
  $CATEGORY_BLOCK
  $CATEGORY_DESIGN
  $CATEGORY_PAGE
  $CATEGORY_PARTNER
  $CATEGORY_PRODUCT

  $YNDX_PARTNER_INTAPI_USER_ID
  $CATEGORY_B_RULE
  $VIDEO_BLOCK_TYPES
  $SITE_VERSIONS
  );

use Application::Model::Product::AN::MobileApp::BlockTypes::Settings qw(
  @BLOCK_TYPES
  );

our @FIELDS = (
    {
        mol_id                 => 'UpdateTime',
        partner2_id            => 'date',
        available_for_everyone => 1,
        label                  => d_gettext('mol_date'),
        frontend_type          => 'date',
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MAIN, $MOL_REPORT_TYPE_DSP, $MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => 'RegionName',
        partner2_id            => 'geo',
        label                  => d_gettext('mol_geo'),
        get_tree2_type         => 'text',
        _group_by              => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_TRAFFIC,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id            => 'PartnerID',
        partner2_id       => 'client_id',
        label             => d_gettext('mol_client_id'),
        hint              => d_gettext('The unique identifier of a partner in Balance'),
        get_tree2_type    => 'publicid',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'categories',
        json_type         => 'number',
        frontend_category => $CATEGORY_PARTNER,
        report_types      => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id            => 'Login',
        partner2_id       => 'login',
        label             => d_gettext('mol_login'),
        get_tree2_type    => 'login',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'categories',
        json_type         => 'string',
        frontend_category => $CATEGORY_PARTNER,
        report_types      => [$MOL_REPORT_TYPE_MAIN, $MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'DSPLogin',
        partner2_id       => 'login',
        label             => d_gettext('mol_login'),
        get_tree2_type    => 'login',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'categories',
        json_type         => 'string',
        frontend_category => $CATEGORY_PARTNER,
        report_types      => [$MOL_REPORT_TYPE_DSP],
    },
    {
        mol_id               => 'BlockModel',
        partner2_id          => 'block_level',
        label                => d_gettext('mol_block_model'),
        get_tree2_type       => 'tree',
        get_tree2_values_sub => '_get_block_model_values',
        where                => TRUE,
        group_by             => TRUE,
        frontend_type        => 'categories',
        json_type            => 'string',
        frontend_category    => $CATEGORY_PRODUCT,
        report_types         => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id               => 'PageModel',
        partner2_id          => 'page_level',
        label                => d_gettext('mol_product_id'),
        get_tree2_type       => 'tree',
        get_tree2_values_sub => '_get_product_id_values',
        where                => TRUE,
        group_by             => TRUE,
        frontend_type        => 'categories',
        json_type            => 'string',
        frontend_category    => $CATEGORY_PRODUCT,
        report_types         => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id            => 'Domain',
        partner2_id       => 'domain',
        label             => d_gettext('mol_domain'),
        get_tree2_type    => 'text',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'categories',
        json_type         => 'string',
        frontend_category => $CATEGORY_PAGE,
        report_types      => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'PageID',
        partner2_id            => 'page_id',
        label                  => d_gettext('mol_page_id'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        json_type              => 'number',
        frontend_type          => 'page_id',
        frontend_category      => $CATEGORY_PAGE,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'PageCaption',
        partner2_id            => 'page_caption',
        label                  => d_gettext('mol_page_caption'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_PAGE,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        # Public ID блока для WHERE. Строки вида R-A-238730-4, R-A-228614-2, ...
        # Этого поля нет в сервере МОЛ в БК.
        # Поэтому есть код, который это поле пребарузет в Page ID + Номер блока
        mol_id                 => 'NoSuchFieldInMolPublicID',
        partner2_id            => 'public_id',
        label                  => d_gettext('mol_public_id'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_BLOCK,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
        hide_in_tree           => 1,
    },
    {
        # В МОЛ — это строки вида video_an_site_instream-189455-10, context_on_site_rtb-99551-8, ...
        mol_id                 => 'ComplexBlockID',
        partner2_id            => 'complex_block_id',
        label                  => d_gettext('mol_public_id'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_BLOCK,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'BlockCaption',
        partner2_id            => 'block_caption',
        label                  => d_gettext('mol_block_caption'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_BLOCK,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id               => 'SiteVersion',
        partner2_id          => 'site_version',
        label                => d_gettext('mol_site_version'),
        get_tree2_type       => 'tree',
        get_tree2_values_sub => '_get_site_version_values',
        where                => TRUE,
        group_by             => TRUE,
        frontend_type        => 'categories',
        json_type            => 'string',
        frontend_category    => $CATEGORY_BLOCK,
        report_types         => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id               => 'BlockType',
        partner2_id          => 'block_type',
        label                => d_gettext('mol_block_type'),
        get_tree2_type       => 'tree',
        get_tree2_values_sub => '_get_block_type_values',
        where                => TRUE,
        group_by             => TRUE,
        frontend_type        => 'categories',
        json_type            => 'string',
        frontend_category    => $CATEGORY_BLOCK,
        report_types         => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id            => 'RtbBlockWithInPageVideo',
        partner2_id       => 'video_in_rtb',
        label             => d_gettext('mol_video_in_rtb'),
        hint              => d_gettext('mol_video_in_rtb_hint'),
        get_tree2_type    => 'boolean',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'boolean',
        json_type         => 'boolean',
        frontend_category => $CATEGORY_BLOCK,
        report_types      => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'VmapID',
        partner2_id            => 'vmap_id',
        label                  => d_gettext('mol_vmap_id'),
        hint                   => d_gettext('mol_vmap_id_hint'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        json_type              => 'number',
        frontend_type          => 'number',
        frontend_category      => $CATEGORY_BLOCK,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'VmapName',
        partner2_id            => 'vmap_name',
        label                  => d_gettext('mol_vmap_name'),
        hint                   => d_gettext('mol_vmap_name_hint'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_BLOCK,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'PartnerStatID',
        partner2_id            => 'tag_id',
        label                  => d_gettext('mol_tag_id'),
        hint                   => d_gettext('mol_tag_id_hint'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'number',
        frontend_category      => $CATEGORY_BLOCK,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'PartnerStatIDCaption',
        partner2_id            => 'tag_name',
        label                  => d_gettext('mol_tag_name'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_BLOCK,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'DesignID',
        partner2_id            => 'design_id',
        label                  => d_gettext('mol_design_id'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        json_type              => 'number',
        is_number_signed       => 1,
        frontend_type          => 'number',
        frontend_category      => $CATEGORY_DESIGN,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'DesignName',
        partner2_id            => 'design_name',
        label                  => d_gettext('mol_design_name'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_DESIGN,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'isAdfox',
        partner2_id            => 'adfox_block',
        label                  => d_gettext('mol_adfox_block'),
        hint                   => d_gettext('mol_adfox_block_hint'),
        get_tree2_type         => 'boolean',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'boolean',
        json_type              => 'boolean',
        frontend_category      => $CATEGORY_ADFOX,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'DealExportID',
        partner2_id            => 'deal_id',
        label                  => d_gettext('mol_deal_id'),
        hint                   => d_gettext('mol_deal_id_hint'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'public_id',
        json_type              => 'number',
        frontend_category      => $CATEGORY_ADFOX,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'DealTitle',
        partner2_id            => 'deal_caption',
        label                  => d_gettext('mol_deal_caption'),
        hint                   => d_gettext('mol_deal_caption_hint'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_ADFOX,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'IsFirstLook',
        partner2_id            => 'first_look',
        label                  => d_gettext('mol_first_look'),
        hint                   => d_gettext('mol_first_look_hint'),
        get_tree2_type         => 'boolean',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'boolean',
        json_type              => 'boolean',
        frontend_category      => $CATEGORY_ADFOX,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id            => 'DSPID',
        partner2_id       => 'dsp_id',
        label             => d_gettext('mol_dsp_id'),
        hint              => d_gettext('mol_dsp_id_hint'),
        get_tree2_type    => 'publicid',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'categories',
        json_type         => 'number',
        frontend_category => $CATEGORY_MONETIZER,
        report_types      => [$MOL_REPORT_TYPE_MAIN, $MOL_REPORT_TYPE_DSP],
    },
    {
        mol_id            => 'DSPCaption',
        partner2_id       => 'dsp_caption',
        label             => d_gettext('mol_dsp_caption'),
        get_tree2_type    => 'text',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'categories',
        json_type         => 'string',
        frontend_category => $CATEGORY_MONETIZER,
        report_types      => [$MOL_REPORT_TYPE_MAIN, $MOL_REPORT_TYPE_DSP],
    },
    {
        mol_id                 => 'DSPDisplayCaption',
        partner2_id            => 'dsp_display_caption',
        label                  => d_gettext('mol_dsp_display_caption'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_MONETIZER,
        available_for_everyone => 1,
        report_types           => [$MOL_REPORT_TYPE_MAIN, $MOL_REPORT_TYPE_DSP],
    },
    {
        mol_id                 => 'RegionID',
        partner2_id            => 'region_id',
        label                  => d_gettext('mol_region_id'),
        get_tree2_type         => 'geo',
        get_tree2_values_sub   => '_get_geobase_values',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'number',
        frontend_category      => $CATEGORY_TRAFFIC,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'OS',
        partner2_id            => 'os',
        label                  => d_gettext('mol_os'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_TRAFFIC,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'Browser',
        partner2_id            => 'browser',
        label                  => d_gettext('mol_browser'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_TRAFFIC,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'BusinessRuleID',
        partner2_id            => 'business_rule_id',
        label                  => d_gettext('mol_business_rule_id'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'number',
        frontend_category      => $CATEGORY_B_RULE,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'BusinessRuleTitle',
        partner2_id            => 'business_rule_name',
        label                  => d_gettext('mol_business_rule_title'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_B_RULE,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },

    # Группа Базовые
    {
        mol_id                 => 'Hits',
        partner2_id            => 'hits',
        get_tree2_type         => 'text',
        label                  => d_gettext('mol_rtb_block_all_hits'),
        hint                   => d_gettext('mol_rtb_block_all_hits_hint'),
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'number',
        frontend_unit          => 'count',
        frontend_category      => $CATEGORY_MOL_BASIC,
        frontend_old_category  => $CATEGORY_COUNTER,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'RenderHits',
        partner2_id            => 'hits_render',
        label                  => d_gettext('mol_rtb_block_hits'),
        hint                   => d_gettext('mol_rtb_block_hits_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'number',
        frontend_unit          => 'count',
        frontend_category      => $CATEGORY_MOL_BASIC,
        frontend_old_category  => $CATEGORY_COUNTER,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'RenderShows',
        partner2_id            => 'shows',
        label                  => d_gettext('mol_rtb_block_shows'),
        hint                   => d_gettext('mol_rtb_block_shows_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'number',
        frontend_unit          => 'count',
        frontend_category      => $CATEGORY_MOL_BASIC,
        frontend_old_category  => $CATEGORY_COUNTER,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => "Impressions1Px",
        partner2_id            => "impressions",
        label                  => d_gettext("mol_impressions_1px"),
        hint                   => d_gettext('mol_impressions_1px_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'number',
        frontend_unit          => 'count',
        frontend_category      => $CATEGORY_MOL_BASIC,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },

    # Аналитические
    {
        mol_id                 => 'RenderHitsRate',
        partner2_id            => 'winrate',
        label                  => d_gettext('mol_rtb_block_winrate'),
        hint                   => d_gettext('mol_rtb_block_winrate_hint'),
        available_for_everyone => 1,
        get_tree2_type         => 'text',
        select                 => TRUE,
        frontend_type          => 'percent',
        frontend_unit          => 'percent',
        frontend_category      => $CATEGORY_MOL_ANALYTIC,
        frontend_old_category  => $CATEGORY_CALCULATED,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'FillRate',
        partner2_id            => 'fillrate',
        label                  => d_gettext('mol_rtb_block_cover_ratio'),
        hint                   => d_gettext('mol_rtb_block_cover_ratio_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'percent',
        frontend_unit          => 'percent',
        frontend_category      => $CATEGORY_MOL_ANALYTIC,
        frontend_old_category  => $CATEGORY_CALCULATED,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => "ShowRate",
        partner2_id            => "showrate",
        label                  => d_gettext("mol_showrate"),
        hint                   => d_gettext('mol_showrate_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'percent',
        frontend_unit          => 'percent',
        frontend_category      => $CATEGORY_MOL_ANALYTIC,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'RenderFillRate',
        partner2_id            => 'visibility',
        label                  => d_gettext('mol_rtb_block_visibility'),
        hint                   => d_gettext('mol_rtb_block_visibility_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'percent',
        frontend_unit          => 'percent',
        frontend_category      => $CATEGORY_MOL_ANALYTIC,
        frontend_old_category  => $CATEGORY_CALCULATED,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },

    # Денежные (без НДС)
    {
        mol_id                => 'Price',
        partner2_id           => 'all_wo_nds',
        label                 => d_gettext('mol_rtb_all_wo_nds'),
        hint                  => d_gettext('mol_rtb_all_wo_nds_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'money',
        frontend_unit         => 'money',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_CASH,
        json_type             => 'number',
        is_float              => 1,
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'MixedPartnerPrice',
        partner2_id            => 'partner_wo_nds',
        label                  => d_gettext('mol_rtb_partner_wo_nds'),
        hint                   => d_gettext('mol_rtb_partner_wo_nds_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'money',
        frontend_unit          => 'money',
        frontend_category      => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category  => $CATEGORY_CASH,
        json_type              => 'number',
        is_float               => 1,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => 'PartnerPrice',
        partner2_id           => 'partner_wo_nds_bk',
        label                 => d_gettext('mol_partner_wo_nds_bk'),
        hint                  => d_gettext('mol_partner_wo_nds_bk_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'money',
        frontend_unit         => 'money',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_CASH,
        json_type             => 'number',
        is_float              => 1,
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => 'CPMV',
        partner2_id           => 'cpmv_all_wo_nds',
        label                 => d_gettext('mol_rtb_block_cpm_all_wo_nds'),
        hint                  => d_gettext('mol_rtb_block_cpm_all_wo_nds_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'money',
        frontend_unit         => 'money',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_CALCULATED_WITH_MONEY,
        json_type             => 'number',
        is_float              => 1,
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'CPMVPartner',
        partner2_id            => 'cpmv_partner_wo_nds',
        label                  => d_gettext('mol_rtb_block_cpm_partner_wo_nds'),
        hint                   => d_gettext('mol_rtb_block_cpm_partner_wo_nds_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'money',
        frontend_unit          => 'money',
        frontend_category      => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category  => $CATEGORY_CALCULATED_WITH_MONEY,
        json_type              => 'number',
        is_float               => 1,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => 'ECPM',
        partner2_id           => 'ecpm_all_wo_nds',
        label                 => d_gettext('mol_rtb_block_cpmh_all_wo_nds'),
        hint                  => d_gettext('mol_rtb_block_cpmh_all_wo_nds_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'money',
        frontend_unit         => 'money',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_CALCULATED_WITH_MONEY,
        json_type             => 'number',
        is_float              => 1,
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'ECPMPartner',
        partner2_id            => 'ecpm_partner_wo_nds',
        label                  => d_gettext('mol_rtb_block_cpmh_partner_wo_nds'),
        hint                   => d_gettext('mol_rtb_block_cpmh_partner_wo_nds_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'money',
        frontend_unit          => 'money',
        frontend_category      => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category  => $CATEGORY_CALCULATED_WITH_MONEY,
        json_type              => 'number',
        is_float               => 1,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => 'RPM',
        partner2_id           => 'rpm_all_wo_nds',
        label                 => d_gettext('mol_rtb_block_rpm_all_wo_nds'),
        hint                  => d_gettext('mol_rtb_block_rpm_all_wo_nds_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'money',
        frontend_unit         => 'money',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_CALCULATED_WITH_MONEY,
        json_type             => 'number',
        is_float              => 1,
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },

    # Дополнительные
    {
        mol_id                 => 'RPMPartner',
        partner2_id            => 'rpm_partner_wo_nds',
        label                  => d_gettext('mol_rtb_block_rpm_partner_wo_nds'),
        hint                   => d_gettext('mol_rtb_block_rpm_partner_wo_nds_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'money',
        frontend_unit          => 'money',
        frontend_category      => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category  => $CATEGORY_CALCULATED_WITH_MONEY,
        json_type              => 'number',
        is_float               => 1,
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'UnsoldHits',
        partner2_id            => 'hits_unsold',
        label                  => d_gettext('mol_rtb_block_hits_unsold'),
        hint                   => d_gettext('mol_rtb_block_hits_unsold_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'number',
        frontend_unit          => 'count',
        frontend_category      => $CATEGORY_MOL_ADDITIONAL,
        frontend_old_category  => $CATEGORY_COUNTER,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'OwnHits',
        partner2_id            => 'hits_own',
        label                  => d_gettext('mol_rtb_block_hits_own_adv'),
        hint                   => d_gettext('mol_rtb_block_hits_own_adv_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'number',
        frontend_unit          => 'count',
        frontend_category      => $CATEGORY_MOL_ADDITIONAL,
        frontend_old_category  => $CATEGORY_COUNTER,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => 'OwnShows',
        partner2_id            => 'shows_own',
        label                  => d_gettext('mol_rtb_block_shows_own_adv'),
        hint                   => d_gettext('mol_rtb_block_shows_own_adv_hint'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'number',
        frontend_unit          => 'count',
        frontend_category      => $CATEGORY_MOL_ADDITIONAL,
        frontend_old_category  => $CATEGORY_COUNTER,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => 'DirectShows',
        partner2_id           => 'shows_direct',
        label                 => d_gettext('mol_rtb_block_direct_shows'),
        hint                  => d_gettext('mol_rtb_block_direct_shows_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_ADDITIONAL,
        frontend_old_category => $CATEGORY_COUNTER,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => 'DirectBannerShows',
        partner2_id           => 'shows_direct_banners',
        label                 => d_gettext('mol_rtb_block_direct_banner_shows'),
        hint                  => d_gettext('mol_rtb_block_direct_banner_shows_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_ADDITIONAL,
        frontend_old_category => $CATEGORY_COUNTER,
        json_type             => 'number',
        sub_is_available      => '_is_shows_direct_banners_available',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => 'DirectBannerClicks',
        partner2_id           => 'clicks_direct',
        label                 => d_gettext('mol_rtb_block_direct_clicks'),
        hint                  => d_gettext('mol_rtb_block_direct_clicks_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_ADDITIONAL,
        frontend_old_category => $CATEGORY_COUNTER,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => 'DirectCtr',
        partner2_id           => 'ctr_direct',
        label                 => d_gettext('mol_rtb_block_direct_ctr'),
        hint                  => d_gettext('mol_rtb_block_direct_ctr_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'float',
        frontend_unit         => 'ctr_percent',
        frontend_category     => $CATEGORY_MOL_ADDITIONAL,
        frontend_old_category => $CATEGORY_CALCULATED,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },

    # По рекомендациям
    {
        mol_id                => "RecommendationRenders",
        partner2_id           => "rec_card_renders",
        label                 => d_gettext("mol_rec_card_renders"),
        hint                  => d_gettext("mol_rec_card_renders_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        sub_is_available      => '_recommendation_widget_available',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => "RecommendationShows",
        partner2_id           => "rec_card_shows",
        label                 => d_gettext("mol_rec_card_shows"),
        hint                  => d_gettext("mol_rec_card_shows_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        sub_is_available      => '_recommendation_widget_available',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => "RecommendationWidgetShows",
        partner2_id           => "rec_widget_shows",
        label                 => d_gettext("mol_rec_widget_shows"),
        hint                  => d_gettext("mol_rec_widget_shows_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        sub_is_available      => '_recommendation_widget_available',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => "RecommendationClicks",
        partner2_id           => "rec_widget_clicks",
        label                 => d_gettext("mol_rec_widget_clicks"),
        hint                  => d_gettext("mol_rec_widget_clicks_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        sub_is_available      => '_recommendation_widget_available',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => "RecommendationCTR",
        partner2_id           => "rec_card_ctr",
        label                 => d_gettext("mol_rec_card_ctr"),
        hint                  => d_gettext("mol_rec_card_ctr_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'float',
        frontend_unit         => 'ctr_percent',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        sub_is_available      => '_recommendation_widget_available',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => "RecommendationWidgetCTR",
        partner2_id           => "rec_widget_ctr",
        label                 => d_gettext("mol_rec_widget_ctr"),
        hint                  => d_gettext("mol_rec_widget_ctr_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'float',
        frontend_unit         => 'ctr_percent',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        sub_is_available      => '_recommendation_widget_available',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => "RecommendationWidgetRequests",
        partner2_id           => "rec_widget_hits",
        label                 => d_gettext("mol_rec_widget_hits"),
        hint                  => d_gettext("mol_rec_widget_hits_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => "RecommendationWidgetRenders",
        partner2_id           => "rec_widget_renders",
        label                 => d_gettext("RecommendationWidgetRenders"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
        hide_in_tree          => TRUE,
    },
    {
        mol_id                => "RecommendationWidgetVisibility",
        partner2_id           => "rec_widget_visibility",
        label                 => d_gettext("mol_rec_widget_visibility"),
        hint                  => d_gettext("mol_rec_widget_visibility_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'percent',
        frontend_unit         => 'percent',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                => "RecommendationWidgetTotalCTR",
        partner2_id           => "rec_widget_ctr_total",
        label                 => d_gettext("mol_rec_widget_ctr_total"),
        hint                  => d_gettext("mol_rec_widget_ctr_total_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'float',
        frontend_unit         => 'ctr_percent',
        frontend_category     => $CATEGORY_MOL_RECOMMENDATIONS,
        frontend_old_category => $CATEGORY_RECOMMENDATIONS,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_MAIN],
    },

    # Для DSP
    {
        mol_id                => "AllDSPHits",
        partner2_id           => "hits_dsp",
        label                 => d_gettext("mol_hits_dsp"),
        hint                  => d_gettext("mol_hits_dsp_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_BASIC,
        frontend_old_category => $CATEGORY_MOL_DSP,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_DSP],
        sub_is_available      => '_dsp_fields_available',
    },
    {
        mol_id                => 'Hits',
        partner2_id           => 'hits',
        get_tree2_type        => 'text',
        label                 => d_gettext('mol_dsp_block_all_hits'),
        hint                  => d_gettext('mol_dsp_block_all_hits_hint'),
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_BASIC,
        frontend_old_category => $CATEGORY_COUNTER,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_DSP],
        sub_is_available      => '_dsp_fields_available',
    },
    {
        mol_id                => 'RenderShows',
        partner2_id           => 'shows',
        label                 => d_gettext('mol_rtb_block_shows'),
        hint                  => d_gettext('mol_rtb_block_shows_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'number',
        frontend_unit         => 'count',
        frontend_category     => $CATEGORY_MOL_BASIC,
        frontend_old_category => $CATEGORY_COUNTER,
        json_type             => 'number',
        report_types          => [$MOL_REPORT_TYPE_DSP],
        sub_is_available      => '_dsp_fields_available',
    },
    {
        mol_id                => "RealPrice",
        partner2_id           => "price_dsp",
        label                 => d_gettext("mol_price_dsp"),
        hint                  => d_gettext("mol_price_dsp_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'money',
        frontend_unit         => 'money',
        currency              => 'RUB',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_MOL_DSP,
        json_type             => 'number',
        is_float              => 1,
        report_types          => [$MOL_REPORT_TYPE_DSP],
        sub_is_available      => '_dsp_fields_available',
    },
    {
        mol_id                => "AverageRealPrice",
        partner2_id           => "price_dsp_average",
        label                 => d_gettext("mol_price_dsp_average"),
        hint                  => d_gettext("mol_price_dsp_average_hint"),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'money',
        frontend_unit         => 'money',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_MOL_DSP,
        json_type             => 'number',
        is_float              => 1,
        currency              => 'RUB',
        report_types          => [$MOL_REPORT_TYPE_DSP],
        sub_is_available      => '_dsp_fields_available',
    },
    {
        mol_id                => 'BillingPrice',
        partner2_id           => 'all_wo_nds',
        label                 => d_gettext('mol_dsp_all_wo_nds'),
        hint                  => d_gettext('mol_dsp_all_wo_nds_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'money',
        frontend_unit         => 'money',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_CASH,
        json_type             => 'number',
        is_float              => 1,
        currency              => 'RUB',
        report_types          => [$MOL_REPORT_TYPE_DSP],
        sub_is_available      => '_dsp_fields_available',
    },
    {
        mol_id                => 'CPMV',
        partner2_id           => 'cpmv_all_wo_nds',
        label                 => d_gettext('mol_dsp_block_cpm_all_wo_nds'),
        hint                  => d_gettext('mol_dsp_block_cpm_all_wo_nds_hint'),
        get_tree2_type        => 'text',
        select                => TRUE,
        frontend_type         => 'float',
        frontend_unit         => 'cpmv',
        frontend_category     => $CATEGORY_MOL_FINANCIAL,
        frontend_old_category => $CATEGORY_CALCULATED_WITH_MONEY,
        json_type             => 'number',
        is_float              => 1,
        report_types          => [$MOL_REPORT_TYPE_DSP],
        sub_is_available      => '_dsp_fields_available',
    },

    ###### Отчет по Мобильной Медиации
    {
        mol_id            => "OwnerID",
        partner2_id       => "owner_id",
        label             => d_gettext("mol_owner_id"),
        get_tree2_type    => 'publicid',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'categories',
        frontend_category => $CATEGORY_PARTNER,
        json_type         => 'string',
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => "ApplicationID",
        partner2_id       => "application_id",
        label             => d_gettext("mol_application_id"),
        get_tree2_type    => 'number',
        where             => TRUE,
        group_by          => TRUE,
        frontend_type     => 'categories',
        frontend_category => $CATEGORY_MOL_APPLICATION,
        json_type         => 'number',
        report_types      => [$MOL_REPORT_TYPE_MM],
        hide_in_tree      => 1,
    },
    {
        mol_id                 => "StoreID",
        partner2_id            => "store_id",
        label                  => d_gettext("mol_store_id"),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_APPLICATION,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => "MobileCaption",
        partner2_id            => "mobile_caption",
        label                  => d_gettext("mol_moblie_caption"),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_APPLICATION,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    # TODO: Платформа - тут еще нужно прорастить справочник (Android/ios) в БК
    {
        mol_id           => "Platform",
        partner2_id      => "platform",
        label            => d_gettext("mol_platform"),
        get_tree2_type   => 'tree',
        get_tree2_values => [
            {
                id        => 'Android',
                key       => 'Android',
                label     => 'Android',
                parent_id => '',
            },
            {
                id        => 'iOS',
                key       => 'iOS',
                label     => 'iOS',
                parent_id => '',
            }
        ],
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_APPLICATION,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => 'PageID',
        partner2_id            => 'mobmed_page_id',
        label                  => d_gettext('mol_mobmed_page_id'),
        hint                   => d_gettext('mol_mobmed_page_id_hint'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        json_type              => 'number',
        frontend_type          => 'page_id',
        frontend_category      => $CATEGORY_MOL_APPLICATION,
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => "PlaceID",
        partner2_id            => "place_id",
        label                  => d_gettext("mol_place_id"),
        get_tree2_type         => 'number',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_ADV_PLACE,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    # TODO: Название рекламного места - ждем БК
    {
        mol_id                 => "PlaceName",
        partner2_id            => "place_name",
        label                  => d_gettext("mol_place_name"),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_ADV_PLACE,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        # В МОЛ — это строки вида video_an_site_instream-189455-10, context_on_site_rtb-99551-8, ...
        mol_id                 => 'ComplexBlockID',
        partner2_id            => 'complex_block_id',
        label                  => d_gettext('mol_mobmed_public_id'),
        hint                   => d_gettext('mol_mobmed_public_id_hint'),
        get_tree2_type         => 'publicid',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_MOL_ADV_PLACE,
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    # TODO: Формат рекламы (Адаптивный, Нативный, etc) - ждем БК
    {
        mol_id                 => 'BlockType',
        partner2_id            => 'block_type',
        label                  => d_gettext('mol_block_type'),
        get_tree2_type         => 'tree',
        get_tree2_values_sub   => '_get_common_block_type_values',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        json_type              => 'string',
        frontend_category      => $CATEGORY_MOL_ADV_PLACE,
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => "MonetizerID",
        partner2_id            => "monetizer_id",
        label                  => d_gettext("mol_monetizer_id"),
        get_tree2_type         => 'number',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_MONITEZATION,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => "MonetizerName",
        partner2_id            => "monetizer_caption",
        label                  => d_gettext("mol_monetizer_caption"),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_MONITEZATION,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    # {
    #     mol_id                 => "CurrencyID",
    #     partner2_id            => "currency_id",
    #     label                  => d_gettext("mol_currency_id"),
    #     get_tree2_type         => 'number',
    #     where                  => TRUE,
    #     available_for_everyone => 1,
    #     frontend_type          => 'categories',
    #     frontend_category      => $CATEGORY_MOL_MONITEZATION,
    #     json_type              => 'number',
    #     report_types           => [$MOL_REPORT_TYPE_MM],
    # },
    {
        mol_id         => "CurrencyCode",
        partner2_id    => "currency_code",
        label          => d_gettext("mol_currency_code"),
        get_tree2_type => 'text',
        # where                  => TRUE,
        # group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_MONITEZATION,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    # {
    #     mol_id                 => "GeoID",
    #     partner2_id            => "geo_id",
    #     label                  => d_gettext("mol_geo_id"),
    #     get_tree2_type         => 'geo',
    #     group_by               => TRUE,
    #     available_for_everyone => 1,
    #     frontend_type          => 'categories',
    #     frontend_category      => $CATEGORY_MOL_MONITEZATION,
    #     json_type              => 'number',
    #     report_types           => [$MOL_REPORT_TYPE_MM],
    # },
    # TODO: ждем БК
    {
        mol_id                 => "GeoName",
        partner2_id            => "geo_name",
        label                  => d_gettext("mol_geo_name"),
        get_tree2_type         => 'text',
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_MOL_MONITEZATION,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'HitsMM',
        partner2_id       => 'hits_mm',
        label             => d_gettext('mol_hits_mm'),
        hint              => d_gettext('mol_hits_mm_hint'),
        get_tree2_type    => 'text',
        select            => TRUE,
        sub_is_available  => '_user_without_new_mobmed_feature',
        frontend_type     => 'number',
        frontend_unit     => 'count',
        frontend_category => $CATEGORY_MOL_BASIC,
        json_type         => 'number',
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'RequestsMM',
        partner2_id       => 'requests_mm',
        label             => d_gettext('mol_requests_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'count',
        frontend_type     => 'number',
        frontend_category => $CATEGORY_MOL_BASIC,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'ServedRequestsMM',
        partner2_id       => 'served_requests_mm',
        label             => d_gettext('mol_served_requests_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'count',
        frontend_type     => 'number',
        frontend_category => $CATEGORY_MOL_BASIC,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => 'ImpressionsMM',
        partner2_id            => 'impressions_mm',
        label                  => d_gettext('mol_impressions_mm'),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'number',
        frontend_unit          => 'count',
        frontend_category      => $CATEGORY_MOL_BASIC,
        json_type              => 'number',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'ClicksMM',
        partner2_id       => 'clicks_mm',
        label             => d_gettext('mol_clicks_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'count',
        frontend_type     => 'number',
        frontend_category => $CATEGORY_MOL_BASIC,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'FillRateMM',
        partner2_id       => 'fill_rate_mm',
        label             => d_gettext('mol_fill_rate_mm'),
        hint              => d_gettext('mol_fill_rate_mm_hint'),
        get_tree2_type    => 'text',
        select            => TRUE,
        sub_is_available  => '_user_without_new_mobmed_feature',
        frontend_type     => 'percent',
        frontend_unit     => 'percent',
        frontend_category => $CATEGORY_MOL_ANALYTIC,
        json_type         => 'number',
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => 'RevenueMM',
        partner2_id            => 'revenue_mm',
        label                  => d_gettext('mol_revenue_mm'),
        hint                   => d_gettext("mol_revenue_mm_hint"),
        get_tree2_type         => 'text',
        select                 => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'money',
        frontend_unit          => 'money',
        frontend_category      => $CATEGORY_MOL_FINANCIAL,
        json_type              => 'number',
        is_float               => 1,
        currency               => 'RUB',
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    # {
    #     mol_id                 => 'RevenueOriginalMMRUBRSYA',
    #     partner2_id            => 'revenue_original_mm_rubrsya',
    #     label                  => d_gettext('mol_revenue_original_mm_rubrsya'),
    #     hint                   => d_gettext('mol_revenue_original_mm_rubrsya_hint'),
    #     get_tree2_type         => 'text',
    #     select                 => TRUE,
    #     available_for_everyone => 1,
    #     frontend_type          => 'money',
    #     frontend_unit          => 'money',
    #     frontend_category      => $CATEGORY_MOL_FINANCIAL,
    #     json_type              => 'number',
    #     is_float               => 1,
    #     currency               => 'RUB',
    #     report_types           => [$MOL_REPORT_TYPE_MM],
    # },
    # мультивалютность
    {
        mol_id            => 'RevenueOriginalMMRUB',
        partner2_id       => 'revenue_original_mm_rub',
        label             => d_gettext('mol_revenue_original_mm_rub'),
        hint              => d_gettext('mol_revenue_original_mm_rub_hint'),
        get_tree2_type    => 'text',
        select            => TRUE,
        frontend_type     => 'money',
        frontend_unit     => 'money',
        frontend_category => $CATEGORY_MOL_FINANCIAL,
        json_type         => 'number',
        is_float          => 1,
        currency          => 'RUB',
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'RevenueOriginalMMUSD',
        partner2_id       => 'revenue_original_mm_usd',
        label             => d_gettext('mol_revenue_original_mm_usd'),
        hint              => d_gettext('mol_revenue_original_mm_usd_hint'),
        get_tree2_type    => 'text',
        select            => TRUE,
        frontend_type     => 'money',
        frontend_unit     => 'money',
        frontend_category => $CATEGORY_MOL_FINANCIAL,
        json_type         => 'number',
        is_float          => 1,
        currency          => 'USD',
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'RevenueOriginalMMEUR',
        partner2_id       => 'revenue_original_mm_eur',
        label             => d_gettext('mol_revenue_original_mm_eur'),
        hint              => d_gettext('mol_revenue_original_mm_eur_hint'),
        get_tree2_type    => 'text',
        select            => TRUE,
        frontend_type     => 'money',
        frontend_unit     => 'money',
        frontend_category => $CATEGORY_MOL_FINANCIAL,
        json_type         => 'number',
        is_float          => 1,
        currency          => 'EUR',
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    # {
    #     mol_id                 => 'RevenueMMWithoutRSYA',
    #     partner2_id            => 'revenue_mm_without_rsya',
    #     label                  => d_gettext('mol_revenue_mm_without_rsya'),
    #     get_tree2_type         => 'text',
    #     select                 => TRUE,
    #     available_for_everyone => 1,
    #     frontend_type          => 'money',
    #     frontend_unit          => 'money',
    #     frontend_category      => $CATEGORY_MOL_FINANCIAL,
    #     json_type              => 'number',
    #     is_float               => 1,
    #     report_types           => [$MOL_REPORT_TYPE_MM],
    # },
    {
        mol_id                 => "Developer",
        partner2_id            => "developer",
        label                  => d_gettext("mol_developer"),
        hint                   => d_gettext('mol_developer_hint'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_PAGE,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id                 => "AppleStoreID",
        partner2_id            => "apple_store_id",
        label                  => d_gettext("mol_apple_store_id"),
        hint                   => d_gettext('mol_apple_store_id_hint'),
        get_tree2_type         => 'text',
        where                  => TRUE,
        group_by               => TRUE,
        available_for_everyone => 1,
        frontend_type          => 'categories',
        frontend_category      => $CATEGORY_PAGE,
        json_type              => 'string',
        report_types           => [$MOL_REPORT_TYPE_MAIN],
    },
    {
        mol_id            => 'ShowRateV2MM',
        partner2_id       => 'show_rate_v2_mm',
        label             => d_gettext('mol_show_rate_v2_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'percent',
        frontend_type     => 'percent',
        frontend_category => $CATEGORY_MOL_ADDITIONAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'FillRateV2MM',
        partner2_id       => 'fill_rate_v2_mm',
        label             => d_gettext('mol_fill_rate_v2_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'percent',
        frontend_type     => 'percent',
        frontend_category => $CATEGORY_MOL_ADDITIONAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'CtrMM',
        partner2_id       => 'ctr_mm',
        label             => d_gettext('mol_ctr_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'ctr_percent',
        frontend_type     => 'float',
        frontend_category => $CATEGORY_MOL_ADDITIONAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'eCPMMM',
        partner2_id       => 'ecpm_mm',
        label             => d_gettext('mol_ecpm_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        is_float          => TRUE,
        frontend_unit     => 'money',
        frontend_type     => 'money',
        frontend_category => $CATEGORY_MOL_FINANCIAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'RequestsExternalMM',
        partner2_id       => 'requests_external_mm',
        label             => d_gettext('mol_requests_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'count',
        frontend_type     => 'number',
        frontend_category => $CATEGORY_MOL_BASIC,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'ServedRequestsExternalMM',
        partner2_id       => 'served_requests_external_mm',
        label             => d_gettext('mol_served_requests_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'count',
        frontend_type     => 'number',
        frontend_category => $CATEGORY_MOL_BASIC,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'ImpressionsExternalMM',
        partner2_id       => 'impressions_external_mm',
        label             => d_gettext('mol_impressions_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'count',
        frontend_type     => 'number',
        frontend_category => $CATEGORY_MOL_BASIC,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'ClicksExternalMM',
        partner2_id       => 'clicks_external_mm',
        label             => d_gettext('mol_clicks_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'count',
        frontend_type     => 'number',
        frontend_category => $CATEGORY_MOL_BASIC,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'ShowRateExternalMM',
        partner2_id       => 'show_rate_external_mm',
        label             => d_gettext('mol_show_rate_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'percent',
        frontend_type     => 'percent',
        frontend_category => $CATEGORY_MOL_ADDITIONAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'FillRateExternalMM',
        partner2_id       => 'fill_rate_external_mm',
        label             => d_gettext('mol_fill_rate_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'percent',
        frontend_type     => 'percent',
        frontend_category => $CATEGORY_MOL_ADDITIONAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'RevenueExternalMM',
        partner2_id       => 'revenue_external_mm',
        label             => d_gettext('mol_revenue_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        is_float          => TRUE,
        frontend_unit     => 'money',
        frontend_type     => 'money',
        frontend_category => $CATEGORY_MOL_FINANCIAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'CtrExternalMM',
        partner2_id       => 'ctr_external_mm',
        label             => d_gettext('mol_ctr_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        frontend_unit     => 'ctr_percent',
        frontend_type     => 'float',
        frontend_category => $CATEGORY_MOL_ADDITIONAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id            => 'eCPMExternalMM',
        partner2_id       => 'ecpm_external_mm',
        label             => d_gettext('mol_ecpm_external_mm'),
        select            => TRUE,
        get_tree2_type    => 'text',
        json_type         => 'number',
        is_float          => TRUE,
        frontend_unit     => 'money',
        frontend_type     => 'money',
        frontend_category => $CATEGORY_MOL_FINANCIAL,
        report_types      => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => 'ExperimentIdMM',
        partner2_id            => 'experiment_id_mm',
        label                  => d_gettext('mol_experiment_id_mm'),
        where                  => TRUE,
        group_by               => TRUE,
        get_tree2_type         => 'publicid',
        json_type              => 'number',
        frontend_type          => 'number',
        frontend_category      => $CATEGORY_MOL_ADDITIONAL,
        available_for_everyone => TRUE,
        hide_in_tree           => TRUE,
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
    {
        mol_id                 => 'ExperimentGroupIdMM',
        partner2_id            => 'experiment_group_id_mm',
        label                  => d_gettext('mol_experiment_group_id_mm'),
        where                  => TRUE,
        group_by               => TRUE,
        get_tree2_type         => 'publicid',
        json_type              => 'number',
        frontend_type          => 'number',
        frontend_category      => $CATEGORY_MOL_ADDITIONAL,
        available_for_everyone => TRUE,
        hide_in_tree           => TRUE,
        report_types           => [$MOL_REPORT_TYPE_MM],
    },
);

1;
