package Application::Model::BKStatistics::Utils;
use qbit;

sub get_money_for_clients_on_dates {
    my ($self, %opts) = @_;
    my $clients = $opts{clients};
    my $from    = $opts{date_from};
    my $to      = $opts{date_to};

    my %result;
    if (@$clients) {
        my $data = $self->get_statistics2(
            fields        => ["all_wo_nds"],
            period        => [$from, $to],
            stat_type     => "main",
            entity_fields => ["client_id"],
            levels        => [{filter => [AND => [[client_id => IN => $clients]]]}],
        );

        %result = map {$_->{dimensions}{client_id} => $_->{measures}[0]{all_wo_nds}} @{$data->{points} // []};
    }

    return \%result;
}

1;
