package Application::Model::Banks;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'banks'}
sub db_table_name {'bnkseek'}

__PACKAGE__->model_accessors(banks_db => 'Application::Model::BanksDB');

__PACKAGE__->model_fields(
    bic        => {db => 'b', default => TRUE, pk => TRUE},
    name       => {db => 'b', default => TRUE},
    city       => {db => 'b', default => TRUE},
    cityprefix => {db => 'b'},
    correspondentaccount => {db => 'b', default => TRUE},
    cityprefix_name      => {db => 'c', default => TRUE},
    pretty_name          => {
        depends_on => [qw(name city cityprefix_name)],
        get        => sub {
            my $city = $_[1]->{'city'};
            $city =~ s/^\Q$_[1]->{'cityprefix_name'}\E\s*//i;

            return html_decode(join(' ', $_[1]->{'name'}, $_[1]->{'cityprefix_name'}, $_[1]->{'city'}));
          }
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'banks_db',
    fields      => {bic => {type => 'text'}},
);

sub query {
    my ($self, %opts) = @_;

    my $query = $self->banks_db->query->select(
        table  => $self->banks_db->bnkseek,
        fields => $opts{'fields'}->get_db_fields('b'),
        filter => $opts{'filter'},
    );

    $query->join(
        table  => $self->banks_db->cityprefixes,
        fields => $opts{'fields'}->get_db_fields('c'),
    ) if $opts{'fields'}->need('cityprefix_name');

    return $query;
}

1;
