package Application::Model::BanksDB;

use qbit;

use base qw(QBit::Application::Model::DB::mysql);

sub accessor {'banks_db'}

__PACKAGE__->meta(
    tables => {
        bnkseek => {
            fields => [
                {name => 'bic',                  type => 'CHAR',    length   => 9,    not_null => TRUE},
                {name => 'name',                 type => 'VARCHAR', length   => 255,  not_null => TRUE},
                {name => 'city',                 type => 'VARCHAR', length   => 255,  not_null => TRUE},
                {name => 'cityprefix',           type => 'INT',     unsigned => TRUE, not_null => TRUE},
                {name => 'correspondentaccount', type => 'CHAR',    length   => 20,   not_null => TRUE},
            ],
            primary_key => ['bic']
        },

        cityprefixes => {
            fields =>
              [{name => 'cityprefix'}, {name => 'cityprefix_name', type => 'CHAR', length => 255, not_null => TRUE}],
            foreign_keys => [[['cityprefix'] => bnkseek => ['cityprefix']]]
          }

    }
);

1;
