package Application::Model::BannedCountries;

=encoding UTF-8

=head1

Список стран с которыми по российским законам не может заключать договора Яндекс.

http://wiki.yandex-team.ru/partner/w/partner-countries

=cut

use qbit;

use base qw(QBit::Application::Model);

sub accessor {'banned_countries'}

=head1 get_counrties_ids

Возвращает id стран из geobase с которыми Яндекс не может работать.

    my @ids = $app->banned_countries->get_countries_ids();

=cut

sub get_countries_ids {
    my ($self) = @_;

    my @ids = (
        134,      # Китай
        210,      # Объединённые Арабские Эмираты
        10022,    # Сейшельские острова
        10029,    # Кокосовые острова
        10067,    # Лихтенштейн
        10070,    # Монако
        10088,    # Андорра
        10089,    # Гибралтар
        10097,    # Малайзия
        10098,    # Мальдивы
        10532,    # Бахрейн
        20274,    # Бруней
        20746,    # Доминика
        20754,    # Сент-Винсент и Гренадины
        20790,    # Сан-Марино
        20856,    # Антигуа и Барбуда
        20860,    # Самоа
        21042,    # Сент-Китс и Невис
        21241,    # Маврикий
        21278,    # Либерия
        21297,    # Коморские острова
        21299,    # Панама
        21325,    # Багамские острова
        21395,    # Сент-Люсия
        21426,    # Гренада
        21534,    # Ангилья
        21536,    # Аруба
        21544,    # Белиз
        21546,    # Бермудские Острова
        21556,    # Вануату
        21559,    # Британские Виргинские острова
        21570,    # Каймановы острова
        21574,    # Острова Кука
        21578,    # Маршалловы острова
        21582,    # Науру
        21589,    # Палау
        37176,    # Монтсеррат
        98542,    # Ниуэ
    );

    return @ids;
}

=head1 is_banned

Возвращает true/false значнеие, является ли переданный id забаненным

    $app->banned_countries->is_banned(225); # вернет false значение
    $app->banned_countries->is_banned(10070); # вернет true значение

=cut

sub is_banned {
    my ($self, $id) = @_;

    my @ids = $self->get_countries_ids();

    return in_array($id, \@ids);
}

TRUE;
