package Application::Model::BkData;

use qbit;
use base qw(QBit::Application::Model RestApi::SimpleModel);

use Exception::Validation::BadArguments;
use Exception::NotFound;

use PiConstants qw($PAGE_KEYS_TRANSFORM);
use Utils::PublicID;

sub accessor {'bkdata'}

sub get_product_name {gettext('bkdata')}

#API

sub api_available_fields {
    return ();
}

sub api_available_actions {
    return qw();
}

sub api_check_public_id {
    return is_page_id($_[1]) || is_block_id($_[1]);
}

sub is_page_id {
    return $_[0] =~ /^[1-9][0-9]*\z/;
}

sub is_block_id {
    return $_[0] =~ /^[A-Z]+-[A-Z]+-\d+-\d+\z/;
}

sub api_get {
    my ($self, $controller, $pk, $resource, %opts) = @_;

    my $result;

    if (is_page_id($pk)) {
        $result = $self->get_page_bk_data($pk, %opts);
    } elsif (is_block_id($pk)) {
        $result = $self->get_block_bk_data($pk, %opts);
    }

    return $result;
}

sub api_get_all {
    my ($self, $controller, $resource, $one_object) = @_;

    return [];
}

sub get_page_bk_data {
    my ($self, $page_id, %opts) = @_;

    my $filter = {page_id => $page_id};

    my $accessor = $opts{accessor};
    $accessor = $self->app->all_pages->get_all(filter => $filter, fields => ['model'])->[0]->{model} unless $accessor;
    throw Exception::NotFound unless $accessor;

    my $model = $self->app->$accessor;
    my $page = $model->get_all(filter => $filter, fields => ['page_id'])->[0]->{page_id};
    throw Exception::NotFound unless $page;

    my $tmp_rights = $self->app->add_all_tmp_rights();
    my $obj        = $model->get_all(
        fields => ['*'],
        filter => $filter
    )->[0];
    throw Exception::NotFound unless $obj;

    my $data_for_bk = $model->_data_for_bk(
        $obj,
        read_only => TRUE,
        $self->_get_bk_data_opts(%opts),
    );

    if ($opts{asis}) {
        return $data_for_bk;
    } else {
        my %bk_data = $self->app->api_bk->_get_bk_data([$data_for_bk]);
        return (values %bk_data)[0];
    }
}

sub get_block_bk_data {
    my ($self, $block_id, %opts) = @_;

    my $p = Utils::PublicID::get_block_accessors_by_public_id_prefixes($self->app);
    my ($prefix, $page, $id) = ($block_id =~ m/^(.*\-)(\d+)\-(\d+)$/);
    my $model = $p->{$prefix}[0];
    throw Exception::NotFound unless $model;

    throw Exception::NotFound unless $self->app->$model->get($block_id, fields => ["public_id"]);

    my $bk_data = $self->get_page_bk_data($page, %opts);

    my $bk_data_blocks_key = $self->app->$model->get_bk_block_data_key();
    unless ($opts{asis}) {
        $bk_data_blocks_key = $PAGE_KEYS_TRANSFORM->{$self->app->$model->get_bk_block_data_key};
    }
    return $bk_data->{$bk_data_blocks_key}{$id};
}

sub get_allowed_params {
    return qw(accessor blocks_from asis);
}

sub _get_bk_data_opts {
    my ($self, %opts) = @_;
    return (
        is_from_java => ('java' eq ($opts{blocks_from} // ''))
          || ('java' eq ($self->app->kv_store->get('bk_data_blocks_from') // '')),
        without_blocks => ('none' eq ($opts{blocks_from} // ''))
          || ('none' eq ($self->app->kv_store->get('bk_data_blocks_from') // '')),
    );
}

1;
