package Application::Model::Block::Content;

use qbit;

use PiConstants qw(
  $DSP_DIRECT_ID
  $DSP_MEDIA_TYPE_ID
  $SITE_VERSIONS_TURBO
  );

use base qw(
  Application::Model::ValidatableMixin
  RestApi::MultistateModel
  );

sub get_dsp_type {[$DSP_MEDIA_TYPE_ID]}

sub get_available_fields {
    my ($self, $obj) = @_;

    my $model_fields = $self->get_model_fields;
    my %fields = map {$_ => TRUE} keys(%$model_fields);

    return \%fields;
}

sub _content_make_fields_defaults {
    my ($self, $opts, $need_fields) = @_;

    my %result = ();

    if ($need_fields->{'page_id'}) {
        $result{'page_id'} = $self->get_all_campaigns_for_adding(
            ($opts->{page_filter} ? (filter   => $opts->{page_filter}) : ()),
            ($opts->{page_limit}  ? (limit    => $opts->{page_limit})  : ()),
            ($opts->{page_sort}   ? (order_by => $opts->{page_sort})   : ()),
        );
    }

    if ($need_fields->{'dsps'}) {
        $result{'dsps_available'} = $self->get_available_dsps($opts->{attributes});
        $result{'dsps_default'}   = $self->get_default_dsps($opts->{attributes});
    }

    if ($need_fields->{'site_version'}) {
        $result{'site_version'} = $self->get_block_site_versions($opts->{attributes});
    }

    if ($need_fields->{'strategy'}) {
        $result{'strategy'} = $self->get_strategies_specification->get_strategies_types($self, $opts->{attributes});
    }

    return \%result;
}

sub _content_fields_depends {
    my ($self) = @_;

    return {
        #если поменялось поле из ключа, то
        #нужно перезапросить поля из значения
        depends => {
            page_id => [qw(dsps site_version)],
            id      => [qw(strategy)],
        },
        #для поля из ключа обязятельно нужно передать поля из значения
        required => {
            dsps         => [qw(page_id)],
            site_version => [qw(page_id)],
            strategy     => [qw(id)],
        },
    };
}

sub _base_get_dsp_rules {
    my ($self) = @_;

    return [
        $self->get_working_on_all_pages_dsp_rule(),
        #PI-13940 Default DSPs - only Direct untill Q2'19
        Partner::DSP::Rule->new(
            default_dsps => Partner::DSP::Rule::Part->new(
                sub => sub {
                    return (limit => {id => $DSP_DIRECT_ID});
                },
            ),
        ),
    ];
}

sub get_dsp_working_on_all_pages_multistate_name {
    'working_on_all_platforms'
}

sub collect_editable_fields {{}}

sub get_available_fields_depends {[]}

sub fix_template { }

sub available_versions {qw(general turbo turbo_desktop)}

sub site_versions_that_depend_on_feature {[]}

sub turbo_desktop_available {FALSE}

sub default_site_version {'general'}

sub can_action_restore {
    my ($self, $block) = @_;

    my $object = $self->_get_object_fields($block, [qw(site_version page)]);

    return FALSE
      if $object->{'site_version'} eq 'turbo_desktop' && !$self->turbo_desktop_available;

    return $self->page->check_action($object->{'page'}, 'restore_block');
}

sub can_action_restore_with_page {
    my ($self, $block) = @_;

    my $object = $self->_get_object_fields($block, [qw(site_version)]);

    return FALSE
      if $object->{'site_version'} eq 'turbo_desktop' && !$self->turbo_desktop_available;

    return TRUE;
}

TRUE;
