package Application::Model::Block::DSPsUnmoderated;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Denied;
use Exception::Validation::BadArguments;

sub accessor      {'block_dsps_unmoderated'}
sub db_table_name {'block_dsps_unmoderated'}

__PACKAGE__->model_accessors(
    all_pages  => 'Application::Model::AllPages',
    dsp        => 'Application::Model::DSP',
    partner_db => 'Application::Model::PartnerDB',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'block_dsps',
            description => d_gettext('Rights to use dsps on Video blocks'),
            rights      => {block_dsps_edit => d_gettext('Right to edit dsp'),},
        },
    ]
);

__PACKAGE__->model_fields(
    page_id  => {default => TRUE, db => TRUE, pk => TRUE,},
    block_id => {default => TRUE, db => TRUE, pk => TRUE,},
    dsp_id   => {default => TRUE, db => TRUE, pk => TRUE,},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        page_id  => {type => 'number', label => d_gettext('Page ID')},
        block_id => {type => 'number', label => d_gettext('Block ID')},
        dsp_id   => {type => 'number', label => d_gettext('DSP ID')},
    }
);

sub edit {
    my ($self, $filter, $data) = @_;

    throw Exception::Denied unless $self->check_short_rights('edit');

    $self->partner_db_table()->edit($self->partner_db->filter($filter), $data);
}

sub replace {
    my ($self, $filter, $dsps, $mode) = @_;

    throw Exception::Denied gettext('You cant save unmoderated dsps')
      unless $self->check_short_rights('edit');

    if (@$dsps == grep {ref($_) eq ''} @$dsps) {
        $dsps = [map {{dsp_id => $_}} @$dsps];
    }

    $self->partner_db->transaction(
        sub {
            $self->partner_db_table()->delete($self->partner_db->filter($filter)) if $mode eq 'edit';

            $self->partner_db_table()->add_multi(
                [
                    map {
                        {%$filter, %$_}
                      } @$dsps
                ]
            );
        }
    );
}

TRUE;
