package Application::Model::Block::External;

use qbit;

use base qw(Application::Model::Block);

use PiConstants qw(
  $INTERNAL_DSP_TAGS
  );

sub get_structure_model_accessors {
    my ($class) = @_;

    return {
        assistants        => 'Application::Model::Assistants',
        agreement_checker => 'Application::Model::AgreementChecker',
    };
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    my $rights = $self->SUPER::get_structure_rights_to_register();

    $rights->[0]{'rights'} = {
        %{$rights->[0]{'rights'}},
        map {$self->get_description_right($_)}
          qw(
          view_field__is_tutby
          ),
    };

    return $rights;
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields()},
        login => {
            depends_on => ['page_id', 'pages.login'],
            label      => d_gettext('Login'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'login'};
            },
            type => 'string',
            api  => 1,
        },
        owner_id => {
            depends_on => ['page_id', 'pages.owner_id'],
            label      => d_gettext('Owner_id'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'owner_id'};
            },
            type        => 'number',
            api         => 1,
            adjust_type => 'str',
        },
        owner_client_id => {
            depends_on => ['page_id', 'pages.client_id'],
            label      => d_gettext('Client ID'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'client_id'};
            },
            type        => 'number',
            adjust_type => 'str',
        },
        is_tutby => {
            depends_on => ['page_id', 'pages.is_tutby'],
            label      => d_gettext('Partner TUT.BY'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'is_tutby'};
            },
            type        => 'boolean',
            adjust_type => 'str',
        },
        cur_user_is_read_assistant => {
            depends_on => ['page_id', 'pages.cur_user_is_read_assistant'],
            label      => d_gettext('Current user is read assistant'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'cur_user_is_read_assistant'};
            },
            type        => 'boolean',
            adjust_type => 'str',
        },
        #redefine
        page => {
            depends_on => [
                'page_id', 'pages.id', 'pages.multistate', 'pages.owner_id', 'pages.cur_user_is_read_assistant',
                'pages.caption', 'pages.login', 'pages.owner',
                ($self->accessor eq 'context_on_site_rtb' ? qw(pages.allowed_turbo pages.allowed_amp) : ()),
            ],
            get => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}};
            },
            type => $self->get_campaign_model_name(),
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    my $parent_filter = $self->SUPER::get_structure_model_filter();

    return {
        db_accessor => $parent_filter->{'db_accessor'},
        fields      => {
            %{$parent_filter->{'fields'}},
            is_yandex_block        => {type => 'alias', path => [qw(page owner is_yandex)],},
            is_business_unit_block => {type => 'alias', path => [qw(page owner business_unit)],},
            user_type              => {type => 'alias', path => [qw(page owner user_type)]},
        },
    };
}

sub can_action_edit {
    my ($self, $obj) = @_;

    # Check if page in multistatus - blocked
    return FALSE if $self->page->check_multistate_flag($obj->{'page'}{'multistate'}, 'blocked');
    return FALSE if $self->page->check_multistate_flag($obj->{'page'}{'multistate'}, 'rejected');

    return TRUE;
}

sub check_action {
    my ($self, $object, $action) = @_;

    return FALSE
      unless $self->check_short_rights('edit');

    my %actions_depends = map {$_ => [qw(cur_user_is_read_assistant is_protected)]} qw(restore delete edit);

    foreach (
        qw(
        delete_with_page
        restore_with_page
        start
        stop
        duplicate
        )
      )
    {
        #для duplicate зависимость находится в can_action_duplicate как и должно быть везде.
        #но есть трабл что если ты хочешь переопределить can_action то придётся полностью дублировать логику
        #иначе нужно ломать голову с вызовами _get_object_fields (несколько запросов к базе если не пробрасывать нужные поля дальше)
        $actions_depends{$_} = [qw(cur_user_is_read_assistant)];
    }
    $actions_depends{duplicate} = [qw(cur_user_is_read_assistant is_protected page)];
    my @fields = @{$actions_depends{$action} // []};

    if (@fields) {
        my $obj = $self->_get_object_fields($object, \@fields);

        # сохраняем чтобы позже не делать лишниего запроса в базу за "is_protected" в throw_error_by_action
        $object->{$_} = $obj->{$_} foreach grep {!exists $object->{$_}} keys %$obj;

        return FALSE if $obj->{'cur_user_is_read_assistant'};

        return FALSE
          if exists($obj->{'is_protected'}) && $obj->{'is_protected'} && !$self->check_rights('edit_protected_pages');

        return FALSE
          if $action eq 'duplicate' && $self->page->check_multistate_flag($obj->{'page'}{'multistate'}, 'rejected');
    }

    $self->SUPER::check_action($object, $action);
}

sub get_dsp_rules {
    my ($self) = @_;

    return [
        @{$self->SUPER::get_dsp_rules()},
        Partner::DSP::Rule->new(
            default_dsps => Partner::DSP::Rule::Part->new(
                depends_on => {page => [qw(is_yandex_page business_unit)],},
                sub        => sub {
                    my ($block, $page) = @_;
                    if ($page->{is_yandex_page} || $page->{business_unit}) {
                        return limit => ['tag' => 'IN' => $INTERNAL_DSP_TAGS];
                    } else {
                        return limit => Partner::DSP::Rule::Filter->identity();
                    }
                },
            ),
            turn_on_dsp => Partner::DSP::Rule::Part->new(
                depends_on => {dsp => [qw(tag)],},
                sub        => sub {
                    my ($dsp) = @_;
                    # TODO: all internal-external pages are actually ignored when turning dsp on
                    # is it ok?
                    if (grep {$_ eq $dsp->{tag}} @$INTERNAL_DSP_TAGS) {
                        return limit => Partner::DSP::Rule::Filter->identity();
                    } else {
                        return limit => [AND => [['is_yandex_block', '=', 0], ['is_business_unit_block', '=', 0]]];
                    }
                },
            ),
        ),
    ];
}

sub get_statistics_level {
    return 'advnet_' . $_[0]->accessor;
}

TRUE;
