package Application::Model::Block::External::Content;

use qbit;

use base qw(
  Application::Model::Block::External::Site
  Application::Model::Block::Content
  );

consume qw(
  Application::Model::Role::Block::Has::AdfoxBlock
  Application::Model::Role::Block::Has::BlocksLimit
  Application::Model::Role::Block::Has::ContentBlock
  Application::Model::Role::Block::Has::Tags
  Application::Model::Role::Has::DSPS
  Application::Model::Role::Has::DSPS::GraysiteRule
  Application::Model::Role::Has::DSPS::WorkingOnAllPagesRule
  Application::Model::Role::Has::Readonly
  Application::Model::Role::Has::SiteVersion
  );

sub get_page_id_field_name {'campaign_id'}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        (
            $self->check_rights('view_search_filters__login') ? {name => 'login', label => gettext('Login')}
            : ()
        ),
        (
            $self->check_rights('view_search_filters__user_type') ? {name => 'user_type', label => gettext('User type')}
            : ()
        ),
    ];
}

sub get_available_fields {
    my ($self, $obj) = @_;

    my $fields = $self->SUPER::get_available_fields($obj);

    my $accessor      = $self->accessor();
    my $page_accessor = $self->get_campaign_model_name();

    $self->app->delete_field_by_rights(
        $fields,
        {
            # TODO: outdated?
            $accessor . '_view_field__%s'    => [qw(is_tutby)],
            'do_' . $accessor . '_save_dsps' => 'dsp_list',

            # campaign's right here!
            $page_accessor . '_view_field__%s'    => [qw(login domain_id)],
            $page_accessor . '_view_field__owner' => [qw(owner_client_id)],
        }
    );

    return $fields;
}

sub get_add_fields {{}}

sub can_action_delete {TRUE}

sub can_action_duplicate {return TRUE;}

sub can_action_restore {&Application::Model::Block::Content::can_action_restore}

sub can_action_restore_with_page {&Application::Model::Block::Content::can_action_restore_with_page}

sub get_need_update_in_bk_fields {{}}

sub get_actions_depends {['cur_user_is_read_assistant']}

sub get_dsp_rules {
    my ($self) = @_;

    return [@{$self->SUPER::get_dsp_rules}, $self->get_graysite_dsp_rule, @{$self->_base_get_dsp_rules},];
}

sub get_editable_fields_depends {['cur_user_is_read_assistant']}

sub get_fields_depends {
    my ($self) = @_;
    return $self->_content_fields_depends;
}

sub make_fields_defaults {
    my ($self, $object, $fields, $changed_fields) = @_;

    $self->_content_make_fields_defaults($object, $fields, $changed_fields);
}

TRUE;
