package Application::Model::Block::Internal;

use qbit;

use base qw(Application::Model::Block);

__PACKAGE__->abstract_methods(qw(get_campaign_model_name));

use PiConstants qw(
  $INTERNAL_PAGE_OWNER_LOGIN
  );

sub get_structure_model_accessors {
    my ($class) = @_;

    return {managers => 'Application::Model::Managers',};
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields()},
        owner_id => {
            depends_on => ['page_id', 'pages.owner_id'],
            label      => d_gettext('Owner_id'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'owner_id'};
            },
            type        => 'number',
            api         => 1,
            adjust_type => 'str',
        },
        manager_ids => {
            depends_on   => ['page_id', 'pages.manager_ids'],
            label        => d_gettext('Managers'),
            check_rights => ($self->get_campaign_model_name() . '_view_field__managers'), # page's right!
            get          => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'manager_ids'};
              }
        },
        managers => {
            depends_on   => ['page_id', 'pages.managers'],
            label        => d_gettext('Managers'),
            check_rights => ($self->get_campaign_model_name() . '_view_field__managers'), # page's right!
            get          => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'managers'};
              }
        },
        is_my => {
            depends_on => ['page_id', 'pages.is_my'],
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'is_my'};
            },
        },
        #redefine
        page => {
            depends_on => [
                'page_id', 'pages.id', 'pages.multistate', 'pages.owner_id', 'pages.owner',
                ($self->accessor eq 'internal_context_on_site_rtb' ? qw(pages.allowed_turbo) : ()),
            ],
            get => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}};
            },
            type => $self->get_campaign_model_name(),
        },
        login => {
            db      => TRUE,
            db_expr => \$INTERNAL_PAGE_OWNER_LOGIN,
            type    => 'string',
            api     => 1
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    my $page_id_name = $self->get_page_id_field_name();

    my $parent_filter = $self->SUPER::get_structure_model_filter();
    return {
        db_accessor => $parent_filter->{'db_accessor'},
        fields      => {
            %{$parent_filter->{'fields'}},
            managers => {
                type           => 'subfilter',
                model_accessor => 'managers',
                field          => $page_id_name,
                fk_field       => 'page_id',
                label          => d_gettext('Managers'),
            },
            login => {
                type      => 'text',
                label     => d_gettext('Login'),
                db_filter => sub {
                    return [\$INTERNAL_PAGE_OWNER_LOGIN => $_[1]->[1] => \$_[1]->[2]];
                  }
            },
        }
    };
}

sub can_action_edit {TRUE}

sub check_action {
    my ($self, $object, $action) = @_;

    my $obj = $self->_get_object_fields($object, [qw(is_my is_protected)]);

    # сохраняем чтобы позже не делать лишниего запроса в базу за "is_protected" в throw_error_by_action
    $object->{$_} = $obj->{$_} foreach grep {!exists $object->{$_}} keys %$obj;

    my $is_protected = $obj->{'is_protected'};
    if ($is_protected) {
        return FALSE unless $self->check_rights('edit_protected_pages');
    } else {
        return FALSE
          unless $self->check_short_rights('edit_all')
              || (   $self->check_short_rights('edit')
                  && $obj->{'is_my'});
    }

    $self->SUPER::check_action($object, $action);
}

sub get_statistics_level {
    (my $accessor = $_[0]->accessor) =~ s/^internal_(\w+)$/internal_advnet_$1/;
    return $accessor;
}

TRUE;
