package Application::Model::Block::Internal::Content;

use qbit;

use base qw(
  Application::Model::Block::Internal::Site
  Application::Model::Block::Content
  );

consume qw(
  Application::Model::Role::Block::Has::AdfoxBlock
  Application::Model::Role::Has::SiteVersion
  Application::Model::Role::Block::Has::BlocksLimit
  );

sub get_page_id_field_name {'campaign_id'}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [{name => 'managers.manager.login', label => gettext('Manager\'s login')},];
}

sub get_add_fields {{}}

sub can_action_duplicate {return TRUE;}

sub can_action_restore {&Application::Model::Block::Content::can_action_restore}

sub can_action_restore_with_page {&Application::Model::Block::Content::can_action_restore_with_page}

sub get_need_update_in_bk_fields {{}}

sub get_actions_depends {['is_my']}

sub get_bk_block_data {{}}

sub get_dsp_rules {
    my ($self) = @_;

    return [@{$self->SUPER::get_dsp_rules}, @{$self->_base_get_dsp_rules},];
}

sub get_editable_fields_depends {['is_my']}

sub get_fields_depends {
    my ($self) = @_;

    return $self->_content_fields_depends;
}

sub make_fields_defaults {
    my ($self, $object, $fields, $changed_fields) = @_;

    $self->_content_make_fields_defaults($object, $fields, $changed_fields);
}

TRUE;
