package Application::Model::Block::Internal::Site;

use qbit;

use base qw(Application::Model::Block::Internal);

use Exception::Validator::Fields;

sub get_structure_model_accessors {
    my ($class) = @_;

    return {
        internal_context_on_site_campaign => 'Application::Model::Product::InternalAN::InternalContextOnSite::Campaign',
        internal_search_on_site_campaign  => 'Application::Model::Product::InternalAN::InternalSearchOnSite::Campaign',
    };
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        %{$self->SUPER::get_structure_model_fields()},
        campaign_id => {
            default     => TRUE,
            db          => TRUE,
            pk          => TRUE,
            type        => 'number',
            label       => d_gettext('Campaign ID'),
            hint        => d_gettext('The unique campaign identifier (the same in BK)'),
            adjust_type => 'str',
            need_check  => {
                type  => 'int_un',
                check => sub {
                    my ($qv, $page_id) = @_;
                    $qv->app->validate_page_reachable($page_id);
                  }
            },
        },
        campaign => {
            depends_on => [
                'page_id',       'pages.id',     'pages.multistate', 'pages.owner_id',
                'pages.site_id', 'pages.domain', 'pages.caption'
            ],
            get => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}};
            },
            type => 'internal_context_on_site_campaign',
            api  => 1,
        },
        is_campaign_deleted => {
            depends_on => ['is_page_deleted'],
            get        => sub {
                $_[1]->{'is_page_deleted'};
            },
            type => 'boolean',
            api  => 1
        },
        domain_id => {
            depends_on => ['page_id', 'pages.site_id'],
            label      => d_gettext('Domain ID'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'site_id'};
            },
            check_rights => ($self->get_campaign_model_name() . '_view_field__domain_id'),    # page's right!
            type         => 'number',
            adjust_type  => 'str',
        },
        domain => {
            depends_on => ['page_id', 'pages.domain'],
            label      => d_gettext('Domain'),
            get        => sub {
                $_[0]->{'pages'}{$_[1]->{'page_id'}}{'domain'};
            },
            type => 'string',
            api  => 1
        },
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    my $parent_filter = $self->SUPER::get_structure_model_filter();
    return {
        db_accessor => $parent_filter->{'db_accessor'},
        fields      => {
            %{$parent_filter->{'fields'}},
            campaign_id => {type => 'number', label => d_gettext('Page ID')},
            campaign    => {
                type           => 'subfilter',
                model_accessor => 'page',
                field          => 'campaign_id',
                fk_field       => 'page_id',
                label          => d_gettext('Campaign'),
            },
        }
    };
}

sub on_action_restore {
    my ($self, $block, %opts) = @_;

    $self->maybe_do_action($block, 'start');

    $self->update_in_bk($block) unless $opts{'do_not_update_in_bk'};

    return TRUE;
}

TRUE;
