package Application::Model::Block::Video::MidRoll::INROLL_OVERLAY;

use base "Application::Model::Block::Video::MidRoll::OVERLAY";

use PiConstants qw(
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  );

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    foreach (
        $self->check_rights('video_an_site_instream_can_add_overlay')
        ? qw(allow_multiple_dsp_ads count_positions video_motion)
        : keys %$fields
      )
    {
        delete $fields->{$_};
    }

    return $fields;
}

sub fix_template {
    my ($template) = @_;

    $template->{fields}{repeat}            = {eq => 0};
    $template->{fields}{count_positions}   = {eq => 1};
    $template->{fields}{broadcast_replace} = {eq => undef};
    $template->{fields}{pip}               = {eq => undef};

    # FIXME: this is not in role's lawn and should not be changed here
    $template->{fields}{video_motion} = {eq => 0};
    $template->{fields}{strategy} = {in => [$MIN_CPM_STRATEGY_ID, $MAX_REVENUE_STRATEGY_ID]};

}

1;
