package Application::Model::Block::Video::MidRoll::MIDROLL;

use qbit;
use PiConstants qw($MIDROLL_MIN_START_TIME);

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{$_} = TRUE foreach (
        qw(
        repeat
        )
    );

    if ($obj->{'repeat'} == 0) {
        $fields->{$_} = TRUE foreach (
            qw(
            start_time
            )
        );
    } elsif ($obj->{'repeat'} == 1) {
        $fields->{$_} = TRUE foreach (
            qw(
            start_time
            repeat_after
            max_repeat_count
            )
        );
    } elsif ($obj->{'repeat'} == 2) {
        $fields->{'server_side'} = TRUE;

        if ($obj->{'server_side'} == 1) {
            $fields->{'try_client'} = TRUE;
        }
    }

    # HACK - нужен рефакторинг editable_fields, чтобы можно было добалять и убирать поля,
    # зависимые от значения в другом поле, i.e repeat -> start_time, repeat_after, ...
    $fields->{$_} = TRUE for (qw(start_time repeat_after max_repeat_count));

    $fields->{$_} = TRUE foreach (
        qw(
        broadcast_replace
        )
    );

    if ($obj->{'broadcast_replace'} == 1) {
        $fields->{'pip'} = TRUE;
    }

    # HACK - нужен рефакторинг editable_fields
    $fields->{server_side} = TRUE;

    return $fields;

}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;
}

sub hook_fields_processing_before_validation {
    my ($old_settings, $new_settings) = @_;

    $new_settings->{repeat} //= 0;
    $new_settings->{start_time} //= $MIDROLL_MIN_START_TIME;

    $new_settings->{broadcast_replace} //= 1;
    $new_settings->{pip}               //= 0;
}

sub fix_template {
    my ($template) = @_;
}

sub get_midroll_dsp_rule {
    my ($block, $dsps) = @_;
    return;
}

1;
