package Application::Model::Block::Video::MidRoll::OVERLAY;

use qbit;
use PiConstants qw(
  $MIDROLL_MIN_START_TIME
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  $DSP_DIRECT_ID
  );

use Exception::Validator::Fields;

sub collect_editable_fields {
    my ($self, $obj, $fields) = @_;

    $fields->{$_} = TRUE foreach (
        qw(
        repeat
        start_time
        )
    );

    if ($obj->{'repeat'} == 1) {
        $fields->{$_} = TRUE foreach (
            qw(
            repeat_after
            max_repeat_count
            )
        );
    }

    # HACK - нужен рефакторинг editable_fields, чтобы можно было добалять и убирать поля,
    # зависимые от значения в другом поле, i.e repeat -> start_time, repeat_after, ...
    $fields->{$_} = TRUE for (qw(start_time repeat_after max_repeat_count));

    foreach (
        $self->check_rights('video_an_site_instream_can_add_overlay')
        ? qw(allow_multiple_dsp_ads count_positions video_motion)
        : keys %$fields
      )
    {
        delete $fields->{$_};
    }

    return $fields;
}

sub get_bk_block_data {
    my ($self, $block, $data) = @_;

    $data->{'DirectLimit'} = 1;

    $data->{'AdTypeSet'} = {
        'text'              => 1,
        'media'             => 0,
        'video'             => 0,
        'media-performance' => 0,
        'video-performance' => 0,
        'video-motion'      => 0,
    };
}

sub hook_fields_processing_before_validation {
    my ($old_settings, $new_settings) = @_;

    $new_settings->{repeat} //= 0;
    $new_settings->{start_time} //= $MIDROLL_MIN_START_TIME;

    $new_settings->{count_positions}        //= 1;
    $new_settings->{max_duration}           //= 30;
    $new_settings->{allow_multiple_dsp_ads} //= 0;
    $new_settings->{video_motion}           //= 0;
    $new_settings->{broadcast_replace}      //= undef;
    $new_settings->{pip}                    //= undef;
}

sub fix_template {
    my ($template) = @_;

    $template->{fields}{repeat}            = {in => [0, 1]};
    $template->{fields}{count_positions}   = {eq => 1};
    $template->{fields}{broadcast_replace} = {eq => undef};
    $template->{fields}{pip}               = {eq => undef};

    # FIXME: this is not in role's lawn and should not be changed here
    $template->{fields}{allow_multiple_dsp_ads} = {eq => 0};
    $template->{fields}{video_motion}           = {eq => 0};
    $template->{fields}{strategy}               = {in => [$MIN_CPM_STRATEGY_ID, $MAX_REVENUE_STRATEGY_ID]};

}

sub get_midroll_dsp_rule {
    my ($block, $dsps) = @_;

    throw Exception::Validator::Fields gettext('Overlay block should have Direct DSP only')
      unless ((1 == @$dsps) && ($DSP_DIRECT_ID eq $dsps->[0]));
}

1;
