package Application::Model::CheckAlive::FirstRun;

use qbit;

use Utils::Logger qw(WARN);

our $DATA;

sub get_first_run_result {
    my ($self, %opts) = @_;
    $self->_init_first_run;

    my $res;
    try {
        my $row = from_json($self->kv_store->get($DATA->{key}));
        if ($row->{revision} == $DATA->{rev}) {
            $res = $row->{result};
        }
    };

    return $res;
}

sub set_first_run_result {
    my ($self, $res, %opts) = @_;
    $self->_init_first_run;

    try {
        $self->kv_store->set(
            $DATA->{key},
            to_json(
                {
                    revision => $DATA->{rev},
                    result   => $res
                },
                canonical => TRUE
            )
        );
    };
}

sub _init_first_run {
    my ($self) = @_;

    unless ($DATA) {
        my ($rev, $key, $service);
        my $host = $self->get_option('hostname');
        my $stage = $self->app->get_option("stage", '');
        try {
            my ($pod_id, $box, $wl) =
              $ENV{PORTO_NAME} =~ m|^ISS-AGENT--(\w+)/pod_agent_box_(\w+)/workload_(\w+?)(?:_start)?$|;

            $key     = sprintf "readiness_probe:%s:%s:%s:%s", $stage, $pod_id, $box, $wl;
            $service = sprintf "readness_probe.%s.%s.%s",     $box,   $wl,     $stage;
            $rev     = get_rev_for_workload($wl);
        };
        if ($ENV{PORTO_NAME} && !$key) {
            # когда будет делаться оповещение в juggler, это место надо особенно подчеркнуть
            WARN("CheckAlive FAIL_PARSE_PORTO: $ENV{PORTO_NAME}");
            $key = sprintf "readiness_probe:%s:%s", $stage, $ENV{PORTO_NAME};
            $rev = 1;
        }
        $DATA = {
            key     => $key,
            rev     => $rev,
            service => $service,
            host    => $host,
        };
    }
    return $DATA;
}

sub get_rev_for_workload {
    my ($workload) = @_;

    my $rev;
    my $response = HTTP::Tiny->new->get('http://localhost:1/pod_status');
    if ($response->{success}) {
        for my $row (@{from_json($response->{content})->{workloads}}) {
            if ($row->{id} eq $workload) {
                $rev = $row->{revision};
            }
        }
    }
    return $rev;
}

sub get_service_name {
    my ($self) = @_;

    $self->_init_first_run;

    return $DATA->{service};
}

sub get_host_name {
    my ($self) = @_;

    $self->_init_first_run;

    return $DATA->{host};
}

1;
__END__
ISS-AGENT--fg6ucvzuqv33v5fu/pod_agent_box_PerlApp/workload_intapi_fcgi_start
