package Application::Model::CheckAlive::Net;
use qbit;

use IO::Socket::IP;
use URI ();

sub check_net_alive {
    my ($self, %opts) = @_;

    my $urls = $self->_get_urls_from_config();
    my $skip = $opts{skip} // {};

    my @log;
    for my $row (@$urls) {
        next if $skip->{$row->{model}};
        if (my $msg = $self->_check_connect($row)) {
            push @log, [$row->{model}, $msg, $opts{verbose} ? {host => $row->{host}, port => $row->{port}} : ()];
        }
    }

    return @log ? [sort {$a->[0] cmp $b->[0]} @log] : FALSE;
}

sub _get_urls_from_config {
    my ($self) = @_;

    my $opts = $self->app->{__OPTIONS__};
    my @urls;
    for my $model (keys %$opts) {
        my $url = $opts->{$model};
        next unless ref $url eq 'HASH';
        $url = $url->{url};
        next unless $url;
        my $uri  = new URI($url);
        my $host = $uri->host;
        my $port = $uri->port;

        if ($host && $port) {
            push @urls, {model => $model, url => $url, host => $host, port => $port};
        } else {
            ERROR("CheckAlive(net): FAIL_PARSE_URL '$model' '$url'");
        }
    }

    return \@urls;
}

sub _check_connect {
    my ($self, $row) = @_;

    my $sock = IO::Socket::IP->new(
        PeerHost => $row->{host},
        PeerPort => $row->{port},
        Type     => SOCK_STREAM,
    );

    unless ($sock) {
        return $@;
    } else {
        return;
    }
}
1;
