package Application::Model::CheckAlive::TVM;
use qbit;
use Exception::API;

sub check_tvm_alive {
    my ($self, %opts) = @_;

    my $tvms = $self->_get_tvm_aliases_from_config();
    my $skip = $opts{skip} // {};

    my @log;

    for my $row (@$tvms) {
        next if $skip->{$row->{model}};
        if (my $msg = $self->_check_tvm($row)) {
            push @log, [$row->{model}, $msg];
        }
    }

    return @log ? [sort {$a->[0] cmp $b->[0]} @log] : FALSE;
}

sub _get_tvm_aliases_from_config {
    my ($self) = @_;

    my $opts = $self->app->{__OPTIONS__};
    my @tvms;
    for my $model (keys %$opts) {
        my $row = $opts->{$model};
        next unless ref $row eq 'HASH';
        my $alias = $row->{tvm_alias};
        next unless $alias;
        push @tvms, {model => $model, tvm_alias => $alias};
    }

    return \@tvms;
}

sub _check_tvm {
    my ($self, $row) = @_;

    my $result;
    my $model = $row->{model};
    try {
        unless ($self->app->api_tvm->get_service_ticket($row->{tvm_alias})) {
            $result = 'Cannot get ticket';
        } elsif ($self->app->$model->can('check_tvm_service')) {
            $result = $self->app->$model->check_tvm_service() && 'Invalid TVM ticket';
        } else {
            $result = 'Must have check_tvm_service';
        }
    }
    catch Exception::API with {
        $result = 'Cannot get ticket';
    }
    catch {
        my ($e) = @_;
        $result = $e->message;
    };
    $result .= ' - ' . $row->{tvm_alias} if $result;

    return $result;
}

1;
