package Application::Model::ClickhouseDB::Statistics;

use qbit;

use base qw(QBit::Application::Model::DB::clickhouse);

use PiConstants qw($CLICKHOUSE_STATISTICS_PK);

my $fields = [
    #
    # Blocks
    #

    {name => 'dt', type => 'Date',},
    {
        name   => 'product_id',
        type   => 'Enum8',
        values => [
            'context_on_site_adblock',          'context_on_site_direct',
            'context_on_site_market',           'context_on_site_market_api',
            'context_on_site_mcb',              'context_on_site_rtb',
            'context_on_site_stripe',           'dsp',
            'internal_context_on_site_direct',  'internal_context_on_site_rtb',
            'internal_context_on_site_stripe',  'internal_mobile_app_rtb',
            'internal_search_on_site_direct',   'internal_search_on_site_premium',
            'mobile_app_rtb',                   'search_on_site_direct',
            'search_on_site_market',            'search_on_site_market_api',
            'search_on_site_mcb',               'search_on_site_premium',
            'ssp_context_on_site_rtb',          'ssp_mobile_app_rtb',
            'ssp_video_an_site_rtb',            'video_an_site_fullscreen',
            'video_an_site_inpage',             'video_an_site_instream',
            'context_on_site_adfox',            'context_on_site_campaign',
            'search_on_site_campaign',          'internal_context_on_site_campaign',
            'internal_search_on_site_campaign', 'mobile_app_settings',
            'video_an_site',                    'ssp_context_on_site_campaign',
            'ssp_mobile_app_settings',          'ssp_video_an_site',
            'context_on_site_content',          'mobile_mediation_block',
            'internal_context_on_site_content', 'indoor',
            'indoor_block',                     'outdoor',
            'outdoor_block',                    'context_on_site_natural',
            'internal_context_on_site_natural',
        ],
    },
    {name => 'page_id',                      type => 'UInt32',},
    {name => 'block_id',                     type => 'UInt32',},
    {name => 'dsp_id',                       type => 'UInt32',},
    {name => 'currency_id',                  type => 'UInt16',},
    {name => 'tag_id',                       type => 'UInt32',},
    {name => 'geo_id',                       type => 'Int64',},
    {name => 'category_id',                  type => 'UInt32',},
    {name => 'monetizer_id',                 type => 'UInt32',},
    {name => 'shows',                        type => 'Int64',},
    {name => 'clicks',                       type => 'Int64',},
    {name => 'hits',                         type => 'Int64',},
    {name => 'impressions',                  type => 'Int64',},
    {name => 'direct_clicks',                type => 'Int64',},
    {name => 'direct_shows',                 type => 'Int64',},
    {name => 'all_w_nds',                    type => 'Int64',},
    {name => 'all_wo_nds',                   type => 'Int64',},
    {name => 'partner_w_nds',                type => 'Int64',},
    {name => 'partner_wo_nds',               type => 'Int64',},
    {name => 'bad_shows',                    type => 'Int64',},
    {name => 'bad_hits',                     type => 'Int64',},
    {name => 'bad_win_price_w_nds',          type => 'Int64',},
    {name => 'bad_win_price_wo_nds',         type => 'Int64',},
    {name => 'bad_win_partner_price_w_nds',  type => 'Int64',},
    {name => 'bad_win_partner_price_wo_nds', type => 'Int64',},

    #hits для рюкзака
    {name => 'win_max_positions_count', type => 'Int64',},

    #
    # Site/Mobile/SSP
    #

    {name => 'an_fraud_shows',  type => 'Int64',},
    {name => 'an_fraud_clicks', type => 'Int64',},
    {name => 'an_fraud_hits',   type => 'Int64',},

    {name => 'an_cover_hits',        type => 'Int64',},
    {name => 'an_cover_direct_hits', type => 'Int64',},
    {name => 'an_cover_market_hits', type => 'Int64',},
    {name => 'an_cover_mcb_hits',    type => 'Int64',},

    {name => 'an_cover_senthits', type => 'Int64',},

    # an_rtb_cover_hits, an_mobile_rtb_cover_hits
    {name => 'an_rtb_cover_hits', type => 'Int64',},
    # an_rtb_cover_senthits, an_mobile_rtb_cover_senthits
    {name => 'an_rtb_cover_senthits', type => 'Int64',},
    # an_rtb_cover_direct_hits, an_mobile_rtb_cover_direct_hits
    {name => 'an_rtb_cover_direct_hits', type => 'Int64',},

    # direct_context_page_ad_shows, direct_searh_page_ad_shows
    {name => 'direct_page_ad_shows',  type => 'Int64',},
    {name => 'premium_page_ad_shows', type => 'Int64',},

    # direct_context_hits, direct_search_hits
    {name => 'direct_hits', type => 'Int64',},
    # direct_market_hits, market_search_hits
    {name => 'market_hits', type => 'Int64',},
    # direct_mcb_hits, mcb_search_hits
    {name => 'mcb_hits',     type => 'Int64',},
    {name => 'premium_hits', type => 'Int64',},

    #
    # Video
    #

    {name => 'view',        type => 'Int64',},
    {name => 'open_player', type => 'Int64',},

    #
    # Mobile Mediation
    #

    {name => 'calculated_revenue',          type => 'Int64',},
    {name => 'calculated_revenue_original', type => 'Int64',},

    # можно использовать подзапрос к таблице с блоками, чтобы вытаскивать тип блока
    #{name => 'preroll_shows',    type => 'UInt32',},
    #{name => 'preroll_hits',     type => 'UInt32',},
    #{name => 'preroll_all_hits', type => 'UInt32',},
    #
    #{name => 'postroll_shows',    type => 'UInt32',},
    #{name => 'postroll_hits',     type => 'UInt32',},
    #{name => 'postroll_all_hits', type => 'UInt32',},
    #
    #{name => 'midroll_shows',    type => 'UInt32',},
    #{name => 'midroll_hits',     type => 'UInt32',},
    #{name => 'midroll_all_hits', type => 'UInt32',},
    #
    #{name => 'pauseroll_shows',    type => 'UInt32',},
    #{name => 'pauseroll_hits',     type => 'UInt32',},
    #{name => 'pauseroll_all_hits', type => 'UInt32',},

];

__PACKAGE__->meta(
    tables => {
        statistics => {
            fields => $fields,
            engine => {
                'ReplicatedSummingMergeTree' =>
                  [\'/statistics_pi2', \'{replica}', 'dt', {'' => $CLICKHOUSE_STATISTICS_PK}, \8192]
            }
        },
        statistics_temporary => {
            fields => $fields,
            engine => {'SummingMergeTree' => ['dt', {'' => $CLICKHOUSE_STATISTICS_PK}, \8192]}
        },

        # Additional income
        statistics_additional_income => {
            fields => [
                {name => 'dt',             type => 'Date',},
                {name => 'user_id',        type => 'UInt32',},
                {name => 'currency_id',    type => 'UInt8',},
                {name => 'partner_wo_nds', type => 'Int64',},
            ],
            engine => {
                'ReplicatedSummingMergeTree' =>
                  [\'/statistics_additional_income', \'{replica}', 'dt', {'' => [qw(dt user_id currency_id)]}, \8192]
            }
        },
        statistics_additional_income_temporary => {
            fields => [
                {name => 'dt',             type => 'Date',},
                {name => 'user_id',        type => 'UInt32',},
                {name => 'currency_id',    type => 'UInt8',},
                {name => 'partner_wo_nds', type => 'Int64',},
            ],
            engine => {'SummingMergeTree' => ['dt', {'' => [qw(dt user_id currency_id)]}, \8192]}
        },
        balance_statistics => {
            fields => [
                {name => 'dt',             type => 'Date',},
                {name => 'page_id',        type => 'UInt32',},
                {name => 'imp_id',         type => 'UInt32',},
                {name => 'type_id',        type => 'UInt32',},
                {name => 'dsp_id',         type => 'UInt32',},
                {name => 'tag_id',         type => 'UInt32',},
                {name => 'currency_id',    type => 'UInt16',},
                {name => 'place_id',       type => 'UInt32',},
                {name => 'all_w_nds',      type => 'Int64',},
                {name => 'all_wo_nds',     type => 'Int64',},
                {name => 'dsp_w_nds',      type => 'Int64',},
                {name => 'dsp_wo_nds',     type => 'Int64',},
                {name => 'partner_w_nds',  type => 'Int64',},
                {name => 'partner_wo_nds', type => 'Int64',},
            ],
            engine       => {SummingMergeTree => []},
            partition_by => {toYYYYMM         => ['dt']},
            order_by     => {
                '' => [
                    qw(
                      dt
                      page_id
                      imp_id
                      place_id
                      dsp_id
                      currency_id
                      tag_id
                      type_id
                      )
                ]
            },
        },
        pages_dict_table => {
            fields => [
                {name => 'page_id',    type => 'UInt32'},
                {name => 'caption',    type => 'String'},
                {name => 'domain_id',  type => 'UInt32'},
                {name => 'source_id',  type => 'UInt64'},
                {name => 'owner_id',   type => 'UInt64'},
                {name => 'multistate', type => 'UInt64'},
                {name => 'model',      type => 'String'}
            ],
            engine => {Dictionary => [\'pages_dict']},
        },
        blocks_dict_table => {
            fields => [
                {name => 'model',              type => 'String'},
                {name => 'page_id',            type => 'UInt32'},
                {name => 'id',                 type => 'UInt32'},
                {name => 'caption',            type => 'String'},
                {name => 'multistate',         type => 'UInt64'},
                {name => 'site_version',       type => 'String'},
                {name => 'adfox_block',        type => 'UInt8'},
                {name => 'direct_block',       type => 'String'},
                {name => 'mobile_block_type',  type => 'String'},
                {name => 'video_block_type',   type => 'UInt8'},
                {name => 'media_formats_list', type => 'String'},
                {name => 'disposition_id',     type => 'UInt8'},
                {name => 'place_id',           type => 'UInt32'},
                {name => 'category_id',        type => 'UInt32'},
            ],
            engine => {Dictionary => [\'blocks_dict']},
        },
    },
);

TRUE;
