package Application::Model::CookieMatch::LinkPi;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Validation::BadArguments;
use Exception::HTTPPI::NotFound;

sub accessor      {'cookie_match_link_pi'}
sub db_table_name {'cookie_match_link_pi'}

__PACKAGE__->model_accessors(
    cookie_match => 'Application::Model::CookieMatch',
    partner_db   => 'Application::Model::PartnerDB',
);

__PACKAGE__->model_fields(
    tag_id => {
        default     => TRUE,
        db          => 'links',
        pk          => TRUE,
        label       => d_gettext('ID'),
        adjust_type => 'str',
    },
    page_id => {
        default     => TRUE,
        db          => 'links',
        pk          => TRUE,
        label       => d_gettext('Page ID'),
        adjust_type => 'str',
    },
    tag => {
        db    => 'tags',
        label => d_gettext('Tag'),
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        tag_id  => {type => 'number', label => d_gettext('Tag ID')},
        page_id => {type => 'number', label => d_gettext('Page ID')},
    }
);

sub add {
    my ($self, %opts) = @_;

    $self->app->validator->check(
        data     => \%opts,
        template => {
            type   => 'hash',
            fields => {
                tag_id  => {type => 'int_un'},
                tag     => {type => 'scalar'},
                page_id => {type => 'int_un'},
            }
        },
        throw => TRUE
    );

    $self->partner_db->cookie_match_link_pi->delete($self->partner_db->filter({page_id => $opts{'page_id'}}));

    $self->partner_db->cookie_match_link_pi->add({tag_id => $opts{'tag_id'}, page_id => $opts{'page_id'}});
}

sub delete {
    my ($self, $pk) = @_;

    $self->app->validator->check(
        data     => $pk,
        template => {
            type   => 'hash',
            fields => {
                tag_id  => {type => 'int_un'},
                page_id => {type => 'int_un'},
            }
        },
        throw => TRUE
    );

    $self->get($pk)
      or throw Exception::Validation::BadArguments gettext('This tag not linked with Page ID %s', $pk->{'page_id'});

    $self->partner_db->cookie_match_link_pi->delete($pk);
}

sub query_join {
    my ($self, $query, $opts) = @_;

    my $tag_fields = $opts->{fields}->get_db_fields('tags');
    $query->left_join(
        table  => $self->partner_db->cookie_match,
        fields => $tag_fields,
    ) if %$tag_fields;

    return $query;
}

sub query_fields {'links'}

TRUE;
