package Application::Model::CookieMatch::Owners;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'cookie_match_owners'}
sub db_table_name {'cookie_match_owners'}

__PACKAGE__->model_accessors(
    partner_db => 'Application::Model::PartnerDB::ContextOnSite',
    users      => 'Application::Model::Users'
);

__PACKAGE__->model_fields(
    user_id => {
        default     => TRUE,
        db          => TRUE,
        pk          => TRUE,
        adjust_type => 'str',
    },
    tag_id => {
        default     => TRUE,
        db          => TRUE,
        pk          => TRUE,
        adjust_type => 'str',
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        user_id => {type => 'number', label => d_gettext('User ID')},
        tag_id  => {type => 'number', label => d_gettext('Tag ID')},
        owner   => {
            type           => 'subfilter',
            model_accessor => 'users',
            field          => 'user_id',
            label          => d_gettext('Owner'),
        },
    }
);

sub query_filter {
    my ($self, $filter) = @_;

    $filter->and(['user_id' => '=' => \$self->app->get_option('cur_user', {})->{'id'}])
      unless $self->check_rights('cookie_match_view_all');

    return $filter;
}

sub replace {
    my ($self, $tag_id, $owners) = @_;

    $self->partner_db->transaction(
        sub {
            $self->partner_db_table->delete($self->partner_db->filter({tag_id => $tag_id}));

            $self->partner_db_table->add_multi([map {{tag_id => $tag_id, user_id => $_}} @$owners]);
        }
    );
}

TRUE;
