package Application::Model::Crimea;

use qbit;

use base qw(QBit::Application::Model);

__PACKAGE__->model_accessors(users => 'Application::Model::Users',);

sub accessor {'crimea'}

=encoding UTF-8

=cut

=head2 get_country_id_with_crimea

Возвращает id страны из геобазы к которой относится Крым для указанного
пользователя.

    my $country_id = $app->crimea->get_country_id_with_crimea( $user_id );

=cut

sub get_country_id_with_crimea {
    my ($self, $user_id) = @_;

    my $belarus_id    = 149;
    my $kazakhstan_id = 159;
    my $ukraine_id    = 187;
    my $russia_id     = 225;

    # Если в базе нет страны, то считаем что это пользователь из Украины
    # Выяснение правильно ли это логика идет в тикете st/PI-7521
    my $country_id = $self->users->get($user_id, fields => ['country_id'])->{'country_id'} // $ukraine_id;

    # На основнии https://st.yandex-team.ru/PI-5020#1442224419000
    #
    #  * для партнеров из РФ, Беларуси и Казахстана показываем Крым в составе РФ;
    #  * для всех остальных партнеров - Крым в составе Украины.
    if (in_array($country_id, [$russia_id, $belarus_id, $kazakhstan_id])) {
        return $russia_id;
    } else {
        return $ukraine_id;
    }
}

TRUE;
