package Application::Model::Currency;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'currency'}
sub db_table_name {'currencies'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB::Statistics',);

__PACKAGE__->model_fields(
    id      => {db => TRUE, default => TRUE, pk => TRUE},
    code    => {db => TRUE, default => TRUE},
    symbol  => {db => TRUE, default => TRUE},
    country => {db => TRUE, default => TRUE},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id => {
            type  => 'number',
            label => d_gettext('ID'),
        },
        code => {
            type  => 'text',
            label => d_gettext('CODE'),
        },
    },
);

1;
