package Application::Model::DAC;

use qbit;

use PiConstants qw($TECHNICAL_RTB_BLOCK_ID $ROBOT_ASSISTANT_ROLE_ID);
use PiVariables qw(IGNORE_RTB_ON_DIRECT_SWITHER);

sub limit_filter_active {
    my ($self, $filter) = @_;
    $filter->and(['active', '<>', \0]) unless IGNORE_RTB_ON_DIRECT_SWITHER;
    return $filter;
}

sub limit_filter_view_zero_block {
    my ($self, $filter) = @_;

    $filter->and(['id', '<>', \0]) unless $self->check_short_rights('view_zero_block');

    return $filter;
}

sub limit_filter_view_technical_rtb_block {
    my ($self, $filter, $opts) = @_;
    $filter->and(['id', '<>', \$TECHNICAL_RTB_BLOCK_ID]) unless $self->check_rights('view_technical_rtb_block');
    return $filter;
}

sub limit_filter_by_owner {
    my ($self, $filter) = @_;
    $filter->and({'owner_id', $self->get_option('cur_user', {})->{'id'}}) unless $self->check_short_rights('view_all');
    return $filter;
}

sub limit_filter_by_robot_assistant_or_owner {
    my ($self, $filter) = @_;

    if (exists($self->get_option('cur_user', {})->{'roles'}{$ROBOT_ASSISTANT_ROLE_ID})) {
        $filter->and({'creator_id' => $self->get_option('cur_user', {})->{'id'}});
    } else {
        $self->limit_filter_by_owner($filter);
    }

    return $filter;
}

sub limit_filter_by_user {
    my ($self, $filter) = @_;
    $filter->and({'user_id', $self->get_option('cur_user', {})->{'id'}}) unless $self->check_short_rights('view_all');
    return $filter;
}

sub limit_filter_by_current_user_pages {
    my ($self, $filter) = @_;

    my @filters;
    for my $accessor (sort @{$self->app->product_manager->get_page_model_accessors}) {
        my $model      = $self->app->$accessor;
        my $page_field = $model->get_page_id_field_name;
        push @filters, ['page_id', '= ANY', $model->query(fields => $model->_get_fields_obj($page_field))];
    }

    $filter->and(['OR', \@filters]);

    return $filter;
}

sub limit_filter_by_special {
    my ($self, $filter, $own_field, $accessor, $model_field) = @_;

    my $model = $self->$accessor;

    $filter->and([$own_field, '= ANY', $model->query('fields', $model->_get_fields_obj($model_field))])
      unless $self->check_short_rights('view_all');

    return $filter;
}

sub limit_filter_by_campaign {
    my ($self, $filter, $opts) = @_;

    my $model       = $self->page;
    my $model_field = $model->get_page_id_field_name;
    my $own_field   = $self->get_page_id_field_name;

    $filter->and(
        [
            $own_field, '= ANY',
            $model->query(fields => $model->_get_fields_obj($model_field), options => $opts->{'options'})
        ]
      )
      if !$self->check_short_rights('view_all')
          || exists($self->get_option('cur_user', {})->{'roles'}{$ROBOT_ASSISTANT_ROLE_ID});

    return $filter;
}

sub limit_filter_by_tutby_and_assistant_and_robot_assistant {
    my ($self, $filter, $opts) = @_;

    unless ($self->check_short_rights('view_all')) {
        my $query_opts         = $opts->{'options'}{'query_opts'};
        my $assistant_can_edit = $query_opts && $query_opts->{'assistant_can_edit'};
        my $cur_user           = $self->get_option('cur_user', {})->{'id'};
        my $page_field         = $self->get_page_id_field_name;

        my @or = ([owner_id => '=' => \$cur_user]);

        push @or,
          [
            owner_id => '= ANY' => $self->users->query(
                fields => $self->users->_get_fields_obj(['id']),
                filter => {is_tutby => 1},
            )
          ]
          if $self->check_rights('users_view_all_tutby_partners');

        push @or,
          [
            $page_field => '= ANY' => $self->assistants->query(
                fields => $self->assistants->_get_fields_obj(['page_id']),
                filter => {
                    user_id   => $cur_user,
                    dissabled => 0,
                    (defined($assistant_can_edit) ? (can_edit => $assistant_can_edit) : ()),
                },
            )
          ]
          if $self->check_rights('is_assistant');

        $filter->and(['OR', \@or]);
    }

    if (exists($self->get_option('cur_user', {})->{'roles'}{$ROBOT_ASSISTANT_ROLE_ID})) {
        $filter->and({'creator_id' => $self->get_option('cur_user', {})->{'id'}});
    }

    return $filter;
}

sub limit_filter_tutby {
    my ($self, $filter) = @_;

    unless ($self->check_short_rights('view_all')) {
        my $extra_filter = $self->partner_db->filter([user_id => '=' => \$self->get_option('cur_user', {})->{'id'}]);

        if ($self->check_rights('users_view_all_tutby_partners')) {
            $extra_filter->or(
                [user_id => '= ANY' => $self->users->query(fields => $self->users->_get_fields_obj(['id']),)]);
        }

        $filter->and($extra_filter);
    }

    return $filter;
}

sub limit_filter_by_managers_and_robot_assistant {
    my ($self, $filter) = @_;

    unless ($self->check_short_rights('view_all')) {
        $filter->and(
            [
                id => '= ANY' => $self->partner_db->query->select(
                    table  => $self->partner_db->managers,
                    fields => ['page_id'],
                    filter => {manager_id => $self->get_option('cur_user', {})->{'id'}}
                )
            ]
        );
    }

    if (exists($self->get_option('cur_user', {})->{'roles'}{$ROBOT_ASSISTANT_ROLE_ID})) {
        $filter->and({creator_id => $self->get_option('cur_user', {})->{'id'}});
    }

    return $filter;
}

sub limit_filter_assistant {
    my ($self, $filter, %opts) = @_;

    unless ($self->check_short_rights('view_all')) {
        my $cur_user_id = $self->get_option('cur_user', {})->{'id'};

        my @or = ([user_id => '=' => \$cur_user_id]);
        push @or,
          [
            user_id => '= ANY' => $self->all_pages->query(
                fields => $self->all_pages->_get_fields_obj(['owner_id']),
                filter => [
                    page_id => '= ANY' => $self->assistants->query(
                        fields => $self->assistants->_get_fields_obj(['page_id']),
                        filter => {user_id => $cur_user_id, dissabled => 0},
                    )
                ]
            )
          ]
          if $self->check_rights('is_assistant');

        push @or,
          [
            user_id => '= ANY' => $self->partner_db->query->select(
                table  => $self->partner_db->users,
                fields => ['id'],
                filter => {is_tutby => 1},
            )
          ]
          if $opts{tutby} and $self->check_rights('users_view_all_tutby_partners');

        $filter->and(['OR', \@or]);
    }

    return $filter;
}

sub limit_filter_assistant_mobile_app {
    my ($self, $filter, %opts) = @_;

    unless ($self->check_short_rights('view_all')) {
        if ($self->check_rights('is_assistant')) {
            my $cur_user_id = $self->get_option('cur_user', {})->{'id'};

            my $query = $self->partner_db->query->select(
                table  => $self->partner_db->mobile_app_owner,
                filter => $self->partner_db->filter(
                    [
                        'OR',
                        [
                            [
                                'user_id' => '= ANY' => $self->partner_db->query->select(
                                    table  => $self->partner_db->mobile_app_settings,
                                    filter => $self->partner_db->filter(
                                        [
                                            'context_page_id' => '= ANY' => $self->app->assistants->query(
                                                fields => $self->app->assistants->_get_fields_obj([qw(page_id)]),
                                                filter => {
                                                    user_id   => $cur_user_id,
                                                    dissabled => 0,
                                                },
                                            )
                                        ]
                                    ),
                                    fields => {owner_id => ''},
                                )
                            ],
                            ['user_id' => '=' => \$cur_user_id]
                        ]
                    ]
                ),
                fields => {app_id => ''}
            );

            $filter->and(['OR', [['id' => '= ANY' => $query]]]);
        } else {
            $filter = $self->limit_filter_by_special($filter, 'id', 'mobile_app_owner', 'app_id');
        }
    }
    return $filter;
}

1;
