package Application::Model::DBManager::Base;

use qbit;

use base qw(QBit::Application::Model::DBManager);

use PiConstants qw($COMMON_BLOCKS_TABLE_NAME);

__PACKAGE__->abstract_methods(
    qw(
      db_table_name
      )
);

sub query {
    my ($self, %opts) = @_;

    my $filter = $self->_db->filter($opts{'filter'});
    my $alias  = $self->query_alias;

    $filter = $self->query_filter($filter, \%opts);

    my $is_block_table_with_multiple_models = $self->is_block_table_with_multiple_models();
    if ($is_block_table_with_multiple_models) {
        $filter->and(['model', '=', \$self->accessor()]);
    }

    my $query = $self->_db->query->select(
        table  => $self->partner_db_table(),
        fields => $opts{'fields'}->get_db_fields($self->query_fields),
        filter => $filter,
        ($alias ? (alias => $alias) : ()),
    );

    $query = $self->query_join($query, \%opts);
    return $query;
}

sub query_fields                        {()}
sub query_filter                        {$_[1]}
sub query_join                          {$_[1]}
sub query_alias                         { }
sub is_block_table_with_multiple_models {FALSE}

# NOTE! Аналог ф-ции  _get_stat_table() в статистике (т.к. в иерархии нет подходящих общих предков)
sub partner_db_table {
    my ($self) = @_;

    my $is_block_table_with_multiple_models = $self->is_block_table_with_multiple_models();

    my $db_table_name = $is_block_table_with_multiple_models ? $COMMON_BLOCKS_TABLE_NAME : $self->db_table_name();
    return $self->_db->$db_table_name;
}

TRUE;
