package Application::Model::ErrorBooster;

use qbit;

use base qw(QBit::Application::Model);
use Digest::MD5 qw(md5_hex);

__PACKAGE__->model_accessors(api_selfservice => 'Application::Model::API::Yandex::SelfService',);

sub accessor {'errorbooster'}

my %stage2env = (
    production => 'production',
    test       => 'testing',
    preprod    => 'pre-production',
);

sub parse_stacktrace {
    my ($self, $sentry_data) = @_;

    my $frames = $sentry_data->{'sentry.interfaces.Stacktrace'};
    # когда на стороне EB будет реализовано отображение аргументов, то заменить на эту строку
    # а пока оставляем для того что бы была возможность видеть аргументы
    # my $frames = delete $sentry_data->{'sentry.interfaces.Stacktrace'};

    my @trace;
    for my $frame (@{$frames->{frames}}) {
        # удалям строчки с кодом так ак они там не нужны
        delete @{$frame}{qw(context_line pre_context post_context)};
        push @trace, {
            function => $frame->{function} // '',
            filename => $frame->{filename} // '',
            lineno   => $frame->{lineno}   // '',
            colno    => 0,
            # эту строчку раскоментировать когда EB сможет показывать аргументы вызова
            # args     => $frame->{vars} // '',
        };
    }

    return \@trace;
}

sub convert_and_send {
    my ($self, $exception, $sentry_data) = @_;

    my $trace = $self->parse_stacktrace($sentry_data);

    my $fingerprint;
    if ($sentry_data->{fingerprint}) {
        $fingerprint =
          ref $sentry_data->{fingerprint}
          ? to_json($sentry_data->{fingerprint}, canonical => TRUE)
          : $sentry_data->{fingerprint};
    } else {
        my @trace_for_md5;
        for my $trace_item (@$trace) {
            push @trace_for_md5,
              {
                function => $trace_item->{function},
                lineno   => $trace_item->{lineno}
              };
        }
        $fingerprint = md5_hex(to_json(\@trace_for_md5, canonical => TRUE));
    }

    my %eb_data = (
        # название проекта, для которого пишем ошибки
        project  => 'partner',
        service  => 'perl_backend',
        language => 'perl',

        # окружение development|testing|prestable|production|pre-production
        env => ($stage2env{$self->get_option('stage', '')} // 'development'),

        # хост источника ошибки
        host => $self->get_option('hostname'),

        # версия приложения
        version => $self->get_option('version'),

        # уровень ошибки trace|debug|info|error; алиасы warning - [warn|warning]; critical - [critical|fatal]
        level => $sentry_data->{level},

        # текст ошибки, все сэмплы ошибок будут сгруппированы по этому названию
        message => $exception->message(),

        # источник ошибки
        source => $sentry_data->{logger},

        # тип ошибки, например: network, logic
        sourceType => $sentry_data->{type},

        # текстовый стектрейс
        stack => $exception->as_string(),
        # файл с ошибкой
        file => ($exception->{filename} || $exception->{callstack}[0]{filename}),
        # блок или модуль, в котором произошла ошибка
        block => ($exception->{package} || $exception->{callstack}[0]{package}),
        # метод, в котором произошла ошибка
        method => ($exception->{subroutine} || $exception->{callstack}[0]{subroutine}),

        # yandexuid запроса с событием
        yandexuid => ($self->get_option('cur_user', {})->{id} // 0),

        fingerprint => $fingerprint,

        # произвольный набор полей вида key:string = value:string|object
        # в базе будет хранится как string:string(stringify).
        # Null-значения сюда передавать нельзя!
        additional => {
            (
                map {!defined $_ || ref $_ ? to_json $_ : $_} culprit => $sentry_data->{culprit},
                %{$sentry_data->{tags}                           // {}},
                %{$sentry_data->{extra}                          // {}},
                %{$sentry_data->{'sentry.interfaces.Http'}       // {}},
                %{$sentry_data->{'sentry.interfaces.Stacktrace'} // {}},
            ),
            fingerprint => $fingerprint,
        },

        parsed_stacktrace => $trace,
    );

    $self->api_selfservice->logbroker(
        append_time_name => 'timestamp',
        data             => [\%eb_data],
        topic            => $self->get_option('logbroker_topic'),
    );
}

TRUE;
