package Application::Model::Excluded::Domains;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Validation::BadArguments;

sub accessor      {'excluded_domains'}
sub db_table_name {'excluded_domains'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB',);

__PACKAGE__->model_fields(
    page_id => {default => TRUE, db => TRUE, pk => TRUE},
    domain  => {default => TRUE, db => TRUE, pk => TRUE}
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        page_id => {type => 'number', label      => d_gettext('Page ID')},
        domain  => {type => 'domain', value_type => 'text', label => d_gettext('Domain')},
    }
);

sub replace {
    my ($self, $page_id, $domains, $mode) = @_;

    my %uniq_domains = ();
    my @bad_domains  = ();

    foreach (@$domains) {
        my $domain = get_domain($_);

        if (defined($domain)) {
            $uniq_domains{$domain} = TRUE;
        } else {
            push(@bad_domains, $_);
        }
    }

    throw Exception::Validation::BadArguments gettext('Incorrect domains: %s', join(', ', @bad_domains))
      if @bad_domains;

    my @rows = map {{page_id => $page_id, domain => $_}} sort keys(%uniq_domains);

    $self->partner_db->transaction(
        sub {
            $self->partner_db->excluded_domains->delete($self->partner_db->filter({page_id => $page_id}))
              if $mode eq 'edit';

            $self->partner_db->excluded_domains->add_multi(\@rows) if @rows;
        }
    );

    return TRUE;
}

TRUE;
