package Application::Model::Excluded::Phones;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Validation::BadArguments;

sub accessor      {'excluded_phones'}
sub db_table_name {'excluded_phones'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB',);

__PACKAGE__->model_fields(
    page_id => {default => TRUE, db => TRUE, pk => TRUE},
    phone   => {default => TRUE, db => TRUE, pk => TRUE}
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        page_id => {type => 'number', label => d_gettext('Page ID')},
        phone   => {type => 'text',   label => d_gettext('Phone')},
    }
);

sub replace {
    my ($self, $page_id, $phones, $mode) = @_;

    my %uniq_phones = ();
    my @bad_phones  = ();

    foreach my $phone (@$phones) {
        my $normal_phone;
        try {
            $normal_phone = get_normalized_phone_or_throw($phone);
        };

        if (defined($normal_phone)) {
            $uniq_phones{$normal_phone} = TRUE;
        } else {
            push(@bad_phones, $phone);
        }
    }

    throw Exception::Validation::BadArguments gettext('Incorrect phones: %s', join(', ', @bad_phones))
      if @bad_phones;

    my @rows = map {{page_id => $page_id, phone => $_}} sort keys(%uniq_phones);

    $self->partner_db->transaction(
        sub {
            $self->partner_db->excluded_phones->delete($self->partner_db->filter({page_id => $page_id}))
              if $mode eq 'edit';

            $self->partner_db->excluded_phones->add_multi(\@rows) if @rows;
        }
    );

    return TRUE;
}

TRUE;
