package Application::Model::Filters;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Validation::BadArguments;

sub accessor      {'filters'}
sub db_table_name {'filters'}

__PACKAGE__->model_accessors(
    partner_db       => 'Application::Model::PartnerDB',
    thematic_filters => 'Application::Model::ThematicFilters',
);

__PACKAGE__->model_fields(
    page_id   => {default => TRUE, db => TRUE, pk => TRUE},
    filter_id => {default => TRUE, db => TRUE, pk => TRUE}
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        page_id   => {type => 'number', label => d_gettext('Page ID')},
        filter_id => {type => 'number', label => d_gettext('Filter ID')},
    }
);

sub replace {
    my ($self, $page_id, $filters, $mode) = @_;

    my $uniq_filters = array_uniq(@$filters);

    my $tmp_rights = $self->app->add_tmp_rights(
        qw(
          filter_view_all
          filter_view_field__id)
    );

    my %thematic_filters =
      map {$_->{'id'} => TRUE} @{$self->thematic_filters->get_all(fields => ['id'], filter => {id => $uniq_filters})};

    undef($tmp_rights);

    my @bad_filters = sort {$a <=> $b} grep {!$thematic_filters{$_}} @$uniq_filters;

    throw Exception::Validation::BadArguments gettext('Incorrect filters ids: %s', join(', ', @bad_filters))
      if @bad_filters;

    my @rows = map {{page_id => $page_id, filter_id => $_}} sort @$uniq_filters;

    $self->partner_db->transaction(
        sub {
            $self->partner_db_table()->delete($self->partner_db->filter({page_id => $page_id})) if $mode eq 'edit';

            $self->partner_db_table()->add_multi(\@rows) if @rows;
        }
    );

    return TRUE;
}

TRUE;
