package Application::Model::InternalSite;

=encoding UTF-8

=cut

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'internal_site'}
sub db_table_name {'internal_site'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB',);

__PACKAGE__->model_fields(
    id        => {default => TRUE, db => TRUE, pk => TRUE, type => 'number'},
    domain    => {default => TRUE, db => TRUE,},
    public_id => {
        depends_on => ['id'],
        get        => sub {
            return $_[1]->{'id'};
        },
    },
    available_fields => {
        get => sub {
            my ($self) = @_;
            return $self->model->get_available_fields();
          }
    },
    editable_fields => {
        get => sub {
            my ($self) = @_;
            return $self->model->get_editable_fields();
          }
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id     => {type => 'number', label => d_gettext('ID'), pk => TRUE},
        domain => {type => 'text',   label => d_gettext('Domain')},
    }
);

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [{name => 'domain', label => gettext('Site')}];
}

sub get_available_fields {
    my ($self) = @_;

    my $model_fields = $self->get_model_fields;
    my %fields = map {$_ => TRUE} keys(%$model_fields);

    return \%fields;
}

sub get_editable_fields {
    return {};
}

sub add {
    my ($self, $domain) = @_;

    return $self->partner_db_table()->add({domain => $domain});
}

TRUE;
