package Application::Model::Log::BkEditPage;

use qbit;
use Compress::Zlib;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'bk_edit_page'}
sub db_table_name {'bk_edit_page'}

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->register_rights($self->get_structure_rights_to_register());
    $self->model_fields($self->get_structure_model_fields());
    $self->model_filter($self->get_structure_model_filter());
}

sub get_structure_model_accessors {
    my ($class) = @_;
    return {partner_logs_db => 'Application::Model::PartnerLogsDB'};
}

sub get_structure_rights_to_register {
    my ($self) = @_;

    my $rights = [
        {
            name        => 'bk_edit_page',
            description => '',
            rights      => {
                map {scalar "bk_edit_page_$_" => "bk_edit_page_$_"}
                  qw(
                  view_bk_send_log
                  ),
            }
        }
    ];

    return $rights;
}

sub get_structure_model_fields {
    my ($self) = @_;

    return {
        id      => {db => TRUE, pk   => 1, default => TRUE, type => 'number'},
        dt      => {db => TRUE, type => 'string'},
        page_id => {db => TRUE, type => 'number'},
        login   => {db => TRUE, type => 'string',},
        request => {
            db      => TRUE,
            db_expr => {uncompress => ['request']},
            get     => sub {
                return Encode::decode_utf8($_[1]->{'request'});
            },
        },
        response => {db => TRUE, type => 'string',},
        error    => {db => TRUE, type => 'string',},
    };
}

sub get_structure_model_filter {
    my ($self) = @_;

    return {
        db_accessor => 'partner_logs_db',
        fields      => {
            id      => {type => 'number', label => d_gettext('ID')},
            page_id => {type => 'number', label => d_gettext('Method')},
            dt      => {type => 'text',   label => d_gettext('Date')},
            login   => {type => 'login',  label => d_gettext('Login')},
        }
    };
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [
        {name => 'page_id', label => gettext('Page ID')},
        {name => 'dt',      label => gettext('DT'), hint => 'YYYY-MM-DD'},
        {name => 'login',   label => gettext('Login')},
    ];
}

sub get_available_fields {
    my ($self, $fields, $obj) = @_;

    my $model_fields = $self->get_model_fields;
    my %fields = map {$_ => TRUE} keys(%$model_fields);

    return \%fields;
}

TRUE;
