package Application::Model::Log::ModelsSoapApi;

use qbit;
use Compress::Zlib;

use base qw(Application::Model::DBManager::Base);

use Exception::Denied;

sub accessor      {'models_soap_api'}
sub db_table_name {'models_soap_api'}

__PACKAGE__->register_rights(
    [
        {
            name        => 'models_soap_api',
            description => d_gettext('Rights to use models_soap_api'),
            rights      => {models_soap_api_view_soap_log => d_gettext('Right to view BK send log'),}
        }
    ]
);

__PACKAGE__->model_accessors(partner_logs_db => 'Application::Model::PartnerLogsDB',);

__PACKAGE__->model_fields(
    id            => {db => TRUE, pk => 1, default => TRUE},
    dt            => {db => TRUE},
    name_module   => {db => TRUE},
    proxy_url     => {db => TRUE},
    uri           => {db => TRUE},
    method        => {db => TRUE},
    params        => {db => TRUE},
    error         => {db => TRUE},
    response_path => {db => TRUE},
    request       => {
        depends_on => ['params'],
        get        => sub {
            return $_[1]->{'params'};
        },
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_logs_db',
    fields      => {
        id     => {type => 'number', label => d_gettext('ID')},
        method => {type => 'text',   label => d_gettext('Method')},
    },
);

sub get_db_filter_simple_fields {
    my ($self) = @_;

    return [{name => 'page_id', label => gettext('Page ID')}];
}

sub query_filter {
    my ($self, $filter) = @_;

    throw Exception::Denied unless $self->check_short_rights('view_soap_log');

    return $filter;
}

TRUE;
