package Application::Model::Managers;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Validation::BadArguments::InvalidManager;
use Exception::Validation::BadArguments;

use PiConstants qw($INTERNAL_YAN_MANAGER_ROLE_ID);

sub accessor      {'managers'}
sub db_table_name {'managers'}

__PACKAGE__->model_accessors(
    partner_db => 'Application::Model::PartnerDB::Managers',
    users      => 'Application::Model::Users'
);

__PACKAGE__->model_fields(
    page_id => {
        default => TRUE,
        db      => 'm',
        pk      => TRUE,
        label   => d_gettext('Page ID')
    },
    manager_id => {
        db => 'm',
        pk => TRUE,
    },
    login => {
        db    => 'u',
        label => d_gettext('Manager\'s login')
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        page_id    => {type => 'number', label => d_gettext('Page ID')},
        manager_id => {type => 'number', label => d_gettext('Manager ID')},
        manager    => {
            type           => 'subfilter',
            model_accessor => 'users',
            field          => 'manager_id',
            fk_field       => 'id',
            label          => d_gettext('Manager'),
        },
    },
);

# Remove somebody as a page manager completely or for some pages only.
#
sub delete {
    my ($self, $manager_id, $page_ids) = @_;

    throw Exception::Validation::BadArguments(
        gettext(
            'Roles: %s are under IDM',
            $self->app->rbac->get_roles(ids => [$INTERNAL_YAN_MANAGER_ROLE_ID])->[0]{name}
        ),
    );
}

sub query {
    my ($self, %opts) = @_;

    return $self->partner_db->query->select(
        table  => $self->partner_db_table(),
        fields => $opts{'fields'}->get_db_fields('m'),
        filter => $opts{'filter'},
      )->join(
        table  => $self->partner_db->users,
        fields => $opts{'fields'}->get_db_fields('u'),
      );
}

sub replace {
    my ($self, $page_id, $managers, $mode) = @_;

    throw Exception::Validation::BadArguments(
        gettext(
            'Roles: %s are under IDM',
            $self->app->rbac->get_roles(ids => [$INTERNAL_YAN_MANAGER_ROLE_ID])->[0]{name}
        ),
    );
}

TRUE;
