package Application::Model::Moderation::BadDomains;

use qbit;

use base qw(QBit::Application::Model);

use Utils::Logger qw(INFOF);

use Exception::Moderation::BadDomains;
use Exception::API::HTTP;

sub accessor {'moderation_bad_domains'}

sub get_structure_model_accessors {
    my ($class) = @_;

    return {
        partner_db         => 'Application::Model::PartnerDB',
        moderation         => 'Application::Model::Moderation',
        stat_download_data => 'Application::Model::StatDownloadData',
    };
}

sub process_file {
    my ($self, $file_path) = @_;

    open(my $fh, '<', $file_path) or throw Exception::Moderation::BadDomains "Failed to open $file_path: $!";

    my $baddomains_exclude = {};
    {
        my $baddomains_exclude_data = $self->app->partner_db->baddomains_exclude->get_all(fields => [qw(domain)]) // [];

        $baddomains_exclude = {map {$_->{domain} => 1} @$baddomains_exclude_data};
    }

    my $page_bad_domains = {
        # <domain> => <hits>
    };
    my $last_page_id = -1;
    while (my $line = <$fh>) {
        chomp($line);

        my ($page_id, $domain, $hits) = split /\t/, $line;

        next if $hits < 1000;

        # В таблице context_on_site_mirrors поле описано так: `domain` varchar(64) NOT NULL,
        # Этот код игнорирует зеркало если оно длиннее чем может влезть в базу.
        # Когда и если появятся хороше зекрала большой длинны эту часть нужно будет переделать
        # (поправить описание в базе и увеличить этот лимит).
        next if length($domain) > 64;

        next if $baddomains_exclude->{$domain};

        $last_page_id = $page_id if $last_page_id == -1;

        # NOTE! Записи в файле уже отсортированы по PageID
        if ($last_page_id != $page_id) {
            $self->process_page_domains($last_page_id, $page_bad_domains);
            $page_bad_domains = {};
        }

        $page_bad_domains->{$domain} = $hits;
        $last_page_id = $page_id;
    }
    close $fh;

    $self->process_page_domains($last_page_id, $page_bad_domains) if %$page_bad_domains;

    return TRUE;
}

sub process_page_domains {
    my ($self, $page_id, $page_bad_domains) = @_;

    my $page_model_data = $self->app->partner_db->all_pages->get_all(
        fields => [qw(id model)],
        filter => {page_id => $page_id, 'model' => [qw(context_on_site_campaign  search_on_site_campaign)]}
    )->[0] // {};

    my $model = $page_model_data->{'model'};

    if ($model) {
        my $mirrors_model = $self->app->$model->mirrors;

        try {
            $mirrors_model->replace(
                {id => $page_model_data->{id}},
                [keys %$page_bad_domains],
                'AUTO_GENERATE_BAD_DOMAINS_MODERATION_REQUESTS'
            ) if $mirrors_model;
        }
        catch Exception::API::HTTP with {
            INFOF 'Got API::HTTP error: %s', shift->message();
        };

    } else {
        INFOF 'Found unsupported model=%s of page_id=%s', $page_id // 'undef', $model // 'undef';
    }

    return 1;
}

1;
