package Application::Model::Monetizers;

=encoding UTF-8

=cut

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'monetizers'}
sub db_table_name {'monetizers'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB');

__PACKAGE__->model_fields(
    id              => {default => TRUE, db => TRUE, pk => TRUE,},
    caption         => {default => TRUE, db => TRUE},
    editable_fields => {
        depends_on => [qw(id)],
        get        => sub {
            $_[0]->model->get_editable_fields();
          }
    },
    available_fields => {
        depends_on => [qw(id)],
        get        => sub {
            return $_[0]->model->get_available_fields();
          }
    },
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {id => {type => 'number'},},
);

sub get_available_fields {
    my ($self) = @_;

    return {
        id      => 1,
        caption => 1,
    };
}

sub get_editable_fields {
    my ($self) = @_;

    return {};
}

TRUE;
