package Application::Model::MultiModel;

use qbit;

use base qw(QBit::Application::Model RestApi::MultistateModel);

use RestApi::Relationships;

use Application::Model::MultiModel::_Utils::Fields;

use Exception::Validation::BadArguments;

__PACKAGE__->abstract_methods(qw(api_check_public_id get_pk_fields get_product_name get_multimodel_restapi_models));

sub get_db_filter_simple_fields {
    my ($self) = @_;

    my $filters = {};

    my @models = $self->get_models();
    foreach my $model (@models) {

        my $filter_simple_fields = $self->app->$model->get_db_filter_simple_fields();

        foreach (map {ref($_) eq 'ARRAY' ? @$_ : $_} @$filter_simple_fields) {
            $filters->{$_->{'name'}}{'data'} //= $_;
            $filters->{$_->{'name'}}{'count'}++;
        }
    }

    my @result = map {$_->{'data'}} grep {$_->{'count'} == @models} map {$filters->{$_}} sort keys %$filters;

    return \@result;
}

sub get_model_fields {
    my ($self) = @_;

    my %fields = ();

    my @models = $self->get_models();
    foreach my $model (@models) {
        my $model_fields = $self->app->$model->get_model_fields();

        foreach my $field_name (sort keys(%$model_fields)) {
            if (!exists($fields{$field_name}) || !exists($fields{$field_name}->{'type'})) {
                $fields{$field_name} = $model_fields->{$field_name};
            }
        }
    }

    return \%fields;
}

#API

sub api_available_fields {
    my ($self) = @_;

    my %all_available_fields = ();
    my %fields               = %{$self->get_model_fields()};
    my @models               = $self->get_models();
    foreach my $accessor (@models) {
        foreach ($self->app->$accessor->api_available_fields()) {
            $all_available_fields{$_} = TRUE if $fields{$_};
        }
    }

    return sort keys(%all_available_fields);
}

sub api_available_actions {
    my ($self) = @_;

    my $actions = {};
    my @models  = $self->get_models();
    foreach my $model (@models) {
        foreach ($self->app->$model->api_available_actions()) {
            $actions->{$_}++;
        }
    }

    return grep {$actions->{$_} == @models} keys(%$actions);
}

sub found_rows {
    my ($self) = @_;

    return $self->{'__FOUND_ROWS__'};
}

sub get_all {
    my ($self, %opts) = @_;

    my @models = $self->get_models();

    $self->{'__LAST_FIELDS__'} = {map {$_ => TRUE} @{$opts{'fields'}}};

    my $meta = {models => {}, all_db_fields => {}, db_fields_general => {}};
    foreach my $model (@models) {
        my $meta_model = $meta->{'models'}{$model} //= {};

        my $model_fields = $self->app->$model->get_model_fields();

        $meta_model->{'fields'} = $self->app->$model->_get_fields_obj([grep {$model_fields->{$_}} @{$opts{'fields'}}]);

        #может быть проблема если в моделе вызываются поля от конкретной таблицы
        $meta_model->{'db_fields'} = $meta_model->{'fields'}->get_db_fields();

        foreach (keys(%{$meta_model->{'db_fields'}})) {
            $meta->{'all_db_fields'}{$_} = TRUE;
            $meta->{'db_fields_general'}{$_}++;
        }
    }

    delete($meta->{'db_fields_general'}{$_})
      foreach grep {$meta->{'db_fields_general'}{$_} != @models} keys(%{$meta->{'db_fields_general'}});

    my @all_db_fields = keys(%{$meta->{'all_db_fields'}});

    my $query;
    foreach my $model (@models) {
        my $meta_model = $meta->{'models'}{$model};

        $meta_model->{'extra_fields'} = [grep {!exists($meta_model->{'db_fields'}{$_})} @all_db_fields];

        my $utils_fields = Application::Model::MultiModel::_Utils::Fields->new(
            db_fields    => $meta_model->{'db_fields'},       # hashref
            extra_fields => $meta_model->{'extra_fields'},    # arrayref
            type_model   => $model
        );

        if (defined($query)) {
            $query->union_all(
                $self->app->$model->query(
                    fields  => $utils_fields,
                    filter  => $self->app->$model->get_db_filter($opts{'filter'}),
                    options => \%opts,
                  )->all_langs($opts{'all_locales'})
            );
        } else {
            $query = $self->app->$model->query(
                fields  => $utils_fields,
                filter  => $self->app->$model->get_db_filter($opts{'filter'}),
                options => \%opts,
            )->all_langs($opts{'all_locales'});
        }
    }

    my $super_query = $self->app->partner_db->query->select(table => $query);

    $super_query->distinct if $opts{'distinct'};

    my @bad_order = grep {!exists($meta->{'db_fields_general'}{$_})} map {ref($_) ? $_->[0] : $_} @{$opts{'order_by'}};
    throw Exception::Validation::BadArguments gettext('Do not support this fields in order: %s', join(', ', @bad_order))
      if @bad_order;

    my @order_by = map {[ref($_) ? ($_->[0], $_->[1]) : ($_, 0)]} @{$opts{'order_by'}};
    $super_query->order_by(@order_by) if @order_by;

    $super_query->limit($opts{'offset'}, $opts{'limit'}) if $opts{'limit'};

    $super_query->calc_rows(1) if $opts{'calc_rows'};

    my $result = $super_query->get_all();

    $self->{'__FOUND_ROWS__'} = $super_query->found_rows() if $opts{'calc_rows'};

    my $hash_result = {};
    foreach my $row (@$result) {
        foreach (@{$meta->{'models'}{$row->{'__MODEL_TYPE__'}}{'extra_fields'}}) {
            delete($row->{$_});
        }

        push(@{$hash_result->{$row->{'__MODEL_TYPE__'}}}, $row);
    }

    if (@$result) {
        foreach my $model (@models) {
            next unless exists($hash_result->{$model});

            my $meta_model = $meta->{'models'}{$model};

            $self->app->$model->pre_process_fields($meta_model->{'fields'}, $hash_result->{$model});
            $hash_result->{$model} = $meta_model->{'fields'}->process_data($hash_result->{$model});
        }
    }

    foreach my $row (@$result) {
        foreach (@{$opts{'fields'}}) {
            $row->{$_} = undef unless exists($row->{$_});
        }
    }

    return $result;
}

sub get_db_filter_fields {
    my ($self) = @_;

    return $self->_get_filter_fields('get_db_filter_fields');
}

sub get_model_filter_fields {
    my ($self) = @_;

    return $self->_get_filter_fields('get_model_filter_fields');
}

sub last_fields {
    my ($self) = @_;

    return $self->{'__LAST_FIELDS__'};
}

sub _get_filter_fields {
    my ($self, $method) = @_;

    my $filters = {};
    my @models  = $self->get_models();
    foreach my $model (@models) {

        my $filter_fields = $self->app->$model->$method();

        foreach my $filter_name (keys(%$filter_fields)) {
            $filters->{$filter_name}{'count'}++;

            #Возможен баг что поля называются одинаково, а фильтры строятся по разному
            if (!exists($filters->{$filter_name}{'data'})) {
                $filters->{$filter_name}{'data'} //= $filter_fields->{$filter_name};
            } elsif ($filter_fields->{$filter_name}{'type'} eq 'dictionary'
                && ref($filter_fields->{$filter_name}{'values'}) eq 'ARRAY')
            {
                # разруливаем различия для dictionary в values
                my %values = map {$_->{'id'} => TRUE} @{$filters->{$filter_name}{'data'}{'values'}};

                my @need_add = grep {!$values{$_->{'id'}}} @{$filter_fields->{$filter_name}{'values'}};

                push(@{$filters->{$filter_name}{'data'}{'values'}}, @need_add) if @need_add;
            }
        }
    }

    return {map {$_ => $filters->{$_}{'data'}} grep {$filters->{$_}{'count'} == @models} keys(%$filters)};
}

sub get_models {
    my ($self) = @_;

    my @model_list = $self->get_multimodel_restapi_models();
    my $available_resources = {map {$_->{resource} => 1} @{$self->app->resources->get_available_resources()}};

    return sort grep {exists $available_resources->{$_}} @model_list;
}

TRUE;
