package Application::Model::MultiModel::Blocks;

use qbit;

use base qw(Application::Model::MultiModel);

sub accessor {'blocks'}

sub get_product_name {gettext('blocks')}

sub api_check_public_id {
    my ($self, $public_id) = @_;

    my $regexp = '';
    foreach my $model ($self->get_models()) {
        $regexp .= ($regexp ? '|' : '') . '(?:' . $self->app->$model->public_id_prefix() . ')';
    }

    $regexp = "^$regexp" . '\d+-\d+\z';

    return $public_id =~ $regexp;
}

sub get_db_filter_simple_fields {
    my ($self) = @_;

    my $filters = $self->SUPER::get_db_filter_simple_fields();

    push(
        @$filters,
        {
            'label' => gettext('Resource'),
            'name'  => 'resource'
        },
        {
            'label' => gettext('Login'),
            'name'  => 'login'
        },
    );

    return $filters;
}

sub get_pk_fields {['page_id', 'id']}

sub get_multimodel_restapi_models {
    qw(
      context_on_site_rtb
      context_on_site_adblock
      mobile_app_rtb
      video_an_site_instream
      video_an_site_inpage

      context_on_site_content
      context_on_site_direct
      context_on_site_natural
      indoor_block
      internal_context_on_site_content
      internal_context_on_site_natural
      internal_context_on_site_rtb
      internal_mobile_app_rtb
      outdoor_block
      video_an_site_fullscreen
      );
}

TRUE;
