package Application::Model::Multistate::DBManager;
# TODO: переименовать в Application::Model::Multistate::DB::Manager

use qbit;

use base qw(QBit::Application::Model::Multistate::DB);

sub action_log_accessor {
    my ($self) = @_;
    my $db_log_table_name = $self->db_table_name() . '_action_log';

    return $self->partner_db->can($db_log_table_name) ? $db_log_table_name : undef;
}

sub partner_db_action_log_table {
    my ($self) = @_;
    my $db_log_table_name = $self->db_table_name() . '_action_log';

    my $action_log_db_table =
        $self->partner_db->can($db_log_table_name)
      ? $self->partner_db->$db_log_table_name
      : undef;

    return $action_log_db_table;
}

sub _action_log_db_table {partner_db_action_log_table(@_)}

sub _get {
    my ($self, $object, %opts) = @_;

    if (ref($object) eq 'ARRAY') {
        my $primary_key = $self->_multistate_db_table()->primary_key;
        $object = {map {$primary_key->[$_] => $object->[$_]} 0 .. (@$primary_key - 1)};
    }

    my $fields = $self->get_model_fields();

    my $tmp_rights;
    $tmp_rights = $self->app->add_tmp_rights(_get_rights($fields->{'multistate'}{'check_rights'}))
      if exists($fields->{'multistate'}{'check_rights'});

    my $data = $self->get($object, %opts);

    undef($tmp_rights);

    return $data;
}

sub _get_rights {
    my ($rights) = @_;

    if (ref($rights) eq 'ARRAY') {
        my @result_rights = ();
        push(@result_rights, _get_rights($_)) foreach @$rights;
        return @result_rights;
    }

    return $rights;
}

sub _multistate_db_table {$_[0]->partner_db_table()}

sub _get_comment {
    my ($self, $object, $action, $opts) = @_;

    my $comment = $self->SUPER::_get_comment($object, $action, $opts);

    if ($self->app->can('system_events')) {
        my $system_events = $self->app->system_events->get_all();

        if (@$system_events) {
            $comment .= length($comment) ? ' ' : '';

            my $system_events_info = join(', ',
                map {$_->{'id'} . ($_->{'details'}{'ticket'} ? " ($_->{'details'}{'ticket'})" : '')} @$system_events);

            $comment .= "system_event_ids: $system_events_info";
        }
    }

    return $comment;
}

TRUE;
