package Application::Model::News;

use qbit;

use base qw(Application::Model::DBManager::Base);

use Exception::Denied;

sub accessor      {'news'}
sub db_table_name {'news'}

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB::News', users => 'Application::Model::Users');

__PACKAGE__->register_rights(
    [
        {
            name        => 'news',
            description => d_gettext('Rights to use news manager'),
            rights      => {
                news_add                 => d_gettext('Right to add news'),
                news_edit                => d_gettext('Right edit news '),
                news_view_field__user_id => d_gettext('Right to view field "user_id"'),
            },
        }
    ]
);

__PACKAGE__->model_fields(
    id          => {default => TRUE, db           => TRUE, pk => TRUE},
    user_id     => {db      => TRUE, check_rights => 'news_view_field__user_id'},
    change_date => {default => TRUE, db           => TRUE},
    date        => {default => TRUE, db           => TRUE},
    title       => {default => TRUE, db           => TRUE},
    text        => {db      => TRUE},
    show_on_main_page => {default => TRUE, db => TRUE},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id                => {type => 'number',  label => d_gettext('ID')},
        title             => {type => 'text',    label => d_gettext('Title')},
        text              => {type => 'text',    label => d_gettext('Text')},
        show_on_main_page => {type => 'boolean', label => d_gettext('Show on main page')},
        owner             => {
            type           => 'subfilter',
            model_accessor => 'users',
            field          => 'user_id',
            label          => d_gettext('Owner'),
        },
    },
);

sub add {
    my ($self, %opts) = @_;

    throw Exception::Denied unless $self->check_short_rights('add');

    return $$self->partner_db_table()->add(
        {
            user_id     => $self->get_option('cur_user')->{'id'},
            change_date => curdate(oformat => 'db_time'),
            map {$_ => $opts{$_}} qw(date title text show_on_main_page)
        }
    );
}

sub edit {
    my ($self, $id, %opts) = @_;

    throw Exception::Denied unless $self->check_short_rights('edit');

    return $$self->partner_db_table()->edit(
        $id,
        {
            change_date => curdate(oformat => 'db_time'),
            map {$_ => $opts{$_}} grep {exists($opts{$_})} qw(date title text show_on_main_page)
        }
    );
}

TRUE;
