package Application::Model::Page::MIXIN::Internal;

use qbit;

use base qw(QBit::Application::Model);

use PiConstants qw($ADINSIDE_CLIENT_ID $ADINSIDE_USER_ID $OWNERS_USER_FIELDS $INTERNAL_PAGE_OWNER_LOGIN );

use Exception::Validation::BadArguments;

sub get_structure_model_accessors {
    my ($class) = @_;

    return {managers => 'Application::Model::Managers',};
}

sub check_action {
    my ($self, $object, $action) = @_;

    my $fields = $self->_get_object_fields($object, [qw(is_my multistate)]);
    throw Exception::Validation::BadArguments gettext('Invalid primary key fields') unless defined($fields);

    my $is_protected = $self->check_multistate_flag($fields->{'multistate'}, 'protected');
    if ($is_protected) {
        return FALSE unless $self->check_rights('edit_protected_pages');
    } else {
        return FALSE
          unless $self->check_rights($self->get_right('edit_all'))
              || (   $self->check_short_rights('edit')
                  && $fields->{'is_my'});
    }

    $self->QBit::Application::Model::Multistate::DB::check_action($object, $action);
}

sub get_internal_structure_model_fields {
    my ($self) = @_;

    return {
        client_id => {
            label => d_gettext('Client id'),
            get   => sub {
                return $ADINSIDE_CLIENT_ID;
            },
            type => 'number',
            api  => 1,
        },
        owner_id => {
            label => d_gettext('Owner id'),
            get   => sub {
                return $ADINSIDE_USER_ID;
            },
            need_check => {type => 'int_un'},
            type       => 'number',
            api        => 1,
        },
        owner => {
            label      => d_gettext('Owner'),
            depends_on => ['owner_id'],
            get        => sub {
                $_[0]->{'__OWNERS__'}->{$ADINSIDE_USER_ID} // {};
            },
            type => 'users',
            api  => 1,
        },
        is_my => {
            forced_depends_on => [qw(manager_ids)],
            get               => sub {
                return in_array($_[0]->model->get_option('cur_user', {})->{'id'}, $_[1]->{'manager_ids'});
            },
            type => 'boolean',
        },
        is_yandex_page => {
            get => sub {
                return 1;
            },
            type        => 'boolean',
            adjust_type => 'int',
        },
        managers => {
            label        => d_gettext('Managers'),
            depends_on   => ['page_id', 'managers.login'],
            check_rights => $self->get_right('view_field__managers'),
            get          => sub {
                return [map {$_->{'login'}} @{$_[0]->{'managers'}->{$_[1]->{'page_id'}} // []}];
            },
            type       => 'array',
            sub_type   => 'string',
            need_check => {
                type     => 'array',
                optional => TRUE,
                all      => {type => 'scalar'},
            },
            api => 1,
        },
        manager_ids => {
            label        => d_gettext('Managers'),
            depends_on   => ['page_id', 'managers.manager_id'],
            check_rights => $self->get_right('view_field__managers'),
            get          => sub {
                return [map {$_->{'manager_id'}} @{$_[0]->{'managers'}->{$_[1]->{'page_id'}} // []}];
            },
            type     => 'array',
            sub_type => 'number',
        },
        available_blocks => {
            depends_on => [qw( multistate )],
            get        => sub {
                return $_[0]->model->get_available_block_model_names($_[1]);
            },
            type     => 'array',
            sub_type => 'string',
            api      => 1,
        },
    };
}

sub get_internal_structure_model_filter {
    my ($self) = @_;

    return {
        page_id => {
            type      => 'number',
            label     => d_gettext('Page ID'),
            db_filter => sub {
                return ['id' => $_[1]->[1] => \$_[1]->[2]];
            },
        },
        managers => {
            type           => 'subfilter',
            model_accessor => 'managers',
            field          => 'id',
            fk_field       => 'page_id',
            label          => d_gettext('Managers'),
        },
    };
}

sub get_internal_structure_rights_to_register {
    my ($self) = @_;

    return {
        map {$self->get_description_right($_)}
          qw(
          edit_field__managers
          view_field__managers
          ),
    };
}

sub internal_related_models {
    my ($self) = @_;

    return {
        managers => {
            accessor => 'managers',
            filter   => sub {
                return {page_id => array_uniq(map {$_->{'page_id'} // ()} @{$_[1]})};
            },
            key_fields => ['page_id'],
            value_type => 'array',
        },
    };
}

sub pre_process_fields {
    my ($self, $fields, $result, %opts) = @_;

    if ($fields->need('owner')) {
        my $tmp_rights = $self->app->add_tmp_rights('users_view_all', 'users_view_field__client_id');
        $fields->{'__OWNERS__'} = {
            map {$_->{'id'} => $_} @{
                $self->users->get_all(
                    fields => $OWNERS_USER_FIELDS,
                    filter => {id => $ADINSIDE_USER_ID},
                )
              }
        };
    }
}

sub get_default_owner_login {$INTERNAL_PAGE_OWNER_LOGIN}

1;
